/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

@Experimental
public class AsyncEventTimeTrigger
extends AsyncTrigger<Object, TimeWindow> {
    private static final long serialVersionUID = 1L;

    private AsyncEventTimeTrigger() {
    }

    @Override
    public StateFuture<TriggerResult> onElement(Object element, long timestamp, TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
        if (window.maxTimestamp() <= ctx.getCurrentWatermark()) {
            return StateFutureUtils.completedFuture(TriggerResult.FIRE);
        }
        ctx.registerEventTimeTimer(window.maxTimestamp());
        return StateFutureUtils.completedFuture(TriggerResult.CONTINUE);
    }

    @Override
    public StateFuture<TriggerResult> onEventTime(long time, TimeWindow window, AsyncTrigger.TriggerContext ctx) {
        return StateFutureUtils.completedFuture(time == window.maxTimestamp() ? TriggerResult.FIRE : TriggerResult.CONTINUE);
    }

    @Override
    public StateFuture<TriggerResult> onProcessingTime(long time, TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
        return StateFutureUtils.completedFuture(TriggerResult.CONTINUE);
    }

    @Override
    public StateFuture<Void> clear(TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
        ctx.deleteEventTimeTimer(window.maxTimestamp());
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public boolean canMerge() {
        return true;
    }

    @Override
    public void onMerge(TimeWindow window, AsyncTrigger.OnMergeContext ctx) {
        long windowMaxTimestamp = window.maxTimestamp();
        if (windowMaxTimestamp > ctx.getCurrentWatermark()) {
            ctx.registerEventTimeTimer(windowMaxTimestamp);
        }
    }

    public String toString() {
        return "AsyncEventTimeTrigger()";
    }

    public static AsyncEventTimeTrigger create() {
        return new AsyncEventTimeTrigger();
    }
}

