/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.ConnectionLimitingFactory;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.IFileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.PluginFileSystemFactory;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.core.fs.UnsupportedSchemeFactory;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.fs.local.LocalFileSystemFactory;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.shaded.guava33.com.google.common.base.Splitter;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableMultimap;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterators;
import org.apache.flink.shaded.guava33.com.google.common.collect.Multimap;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class FileSystem
implements IFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystem.class);
    private static final ReentrantLock OUTPUT_DIRECTORY_INIT_LOCK = new ReentrantLock(true);
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static final HashMap<FSKey, FileSystem> CACHE = new HashMap();
    private static final HashMap<String, FileSystemFactory> FS_FACTORIES = new HashMap();
    private static final FileSystemFactory FALLBACK_FACTORY = FileSystem.loadHadoopFsFactory();
    private static final Multimap<String, String> DIRECTLY_SUPPORTED_FILESYSTEM = ImmutableMultimap.builder().put("wasb", "flink-fs-azure-hadoop").put("wasbs", "flink-fs-azure-hadoop").put("abfs", "flink-fs-azure-hadoop").put("abfss", "flink-fs-azure-hadoop").put("oss", "flink-oss-fs-hadoop").put("s3", "flink-s3-fs-hadoop").put("s3", "flink-s3-fs-presto").put("s3a", "flink-s3-fs-hadoop").put("s3p", "flink-s3-fs-presto").put("gs", "flink-gs-fs-hadoop").build();
    private static final Set<String> ALLOWED_FALLBACK_FILESYSTEMS = new HashSet<String>();
    private static URI defaultScheme;

    @Deprecated
    public static void initialize(Configuration config) throws IllegalConfigurationException {
        FileSystem.initializeWithoutPlugins(config);
    }

    private static void initializeWithoutPlugins(Configuration config) throws IllegalConfigurationException {
        FileSystem.initialize(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Configuration config, @Nullable PluginManager pluginManager) throws IllegalConfigurationException {
        LOCK.lock();
        try {
            CACHE.clear();
            FS_FACTORIES.clear();
            ArrayList<Supplier<Iterator<FileSystemFactory>>> factorySuppliers = new ArrayList<Supplier<Iterator<FileSystemFactory>>>(2);
            factorySuppliers.add(() -> ServiceLoader.load(FileSystemFactory.class).iterator());
            if (pluginManager != null) {
                factorySuppliers.add(() -> Iterators.transform(pluginManager.load(FileSystemFactory.class), PluginFileSystemFactory::of));
            }
            List<FileSystemFactory> fileSystemFactories = FileSystem.loadFileSystemFactories(factorySuppliers);
            for (FileSystemFactory factory : fileSystemFactories) {
                factory.configure(config);
                String scheme = factory.getScheme();
                FileSystemFactory fsf = ConnectionLimitingFactory.decorateIfLimited(factory, scheme, config);
                FS_FACTORIES.put(scheme, fsf);
            }
            FALLBACK_FACTORY.configure(config);
            String stringifiedUri = config.get(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, null);
            if (stringifiedUri == null) {
                defaultScheme = null;
            } else {
                try {
                    defaultScheme = new URI(stringifiedUri);
                }
                catch (URISyntaxException e) {
                    throw new IllegalConfigurationException("The default file system scheme ('" + String.valueOf(CoreOptions.DEFAULT_FILESYSTEM_SCHEME) + "') is invalid: " + stringifiedUri, e);
                }
            }
            ALLOWED_FALLBACK_FILESYSTEMS.clear();
            Iterable<String> allowedFallbackFilesystems = Splitter.on(';').omitEmptyStrings().trimResults().split(config.get(CoreOptions.ALLOWED_FALLBACK_FILESYSTEMS));
            allowedFallbackFilesystems.forEach(ALLOWED_FALLBACK_FILESYSTEMS::add);
        }
        finally {
            LOCK.unlock();
        }
    }

    public static FileSystem getLocalFileSystem() {
        return FileSystemSafetyNet.wrapWithSafetyNetWhenActivated(LocalFileSystem.getSharedInstance());
    }

    public static FileSystem get(URI uri) throws IOException {
        return FileSystemSafetyNet.wrapWithSafetyNetWhenActivated(FileSystem.getUnguardedFileSystem(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public static FileSystem getUnguardedFileSystem(URI fsUri) throws IOException {
        Preconditions.checkNotNull(fsUri, "file system URI");
        LOCK.lock();
        try {
            FileSystem fs;
            FileSystemFactory factory;
            URI uri;
            if (fsUri.getScheme() != null) {
                uri = fsUri;
            } else {
                URI rewrittenUri;
                URI defaultUri;
                block26: {
                    defaultUri = FileSystem.getDefaultFsUri();
                    rewrittenUri = null;
                    try {
                        rewrittenUri = new URI(defaultUri.getScheme(), null, defaultUri.getHost(), defaultUri.getPort(), fsUri.getPath(), null, null);
                    }
                    catch (URISyntaxException e) {
                        if (!defaultUri.getScheme().equals("file")) break block26;
                        try {
                            rewrittenUri = new URI("file", null, new Path(new File(fsUri.getPath()).getAbsolutePath()).toUri().getPath(), null);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                }
                if (rewrittenUri != null) {
                    uri = rewrittenUri;
                } else {
                    throw new IOException("The file system URI '" + String.valueOf(fsUri) + "' declares no scheme and cannot be interpreted relative to the default file system URI (" + String.valueOf(defaultUri) + ").");
                }
            }
            if (uri.getScheme().equals("file") && uri.getAuthority() != null && !uri.getAuthority().isEmpty()) {
                String supposedUri = "file:///" + uri.getAuthority() + uri.getPath();
                throw new IOException("Found local file path with authority '" + uri.getAuthority() + "' in path '" + uri.toString() + "'. Hint: Did you forget a slash? (correct path would be '" + supposedUri + "')");
            }
            FSKey key = new FSKey(uri.getScheme(), uri.getAuthority());
            FileSystem cached = CACHE.get(key);
            if (cached != null) {
                FileSystem e = cached;
                return e;
            }
            if (FS_FACTORIES.isEmpty()) {
                FileSystem.initializeWithoutPlugins(new Configuration());
            }
            if ((factory = FS_FACTORIES.get(uri.getScheme())) != null) {
                ClassLoader classLoader = factory.getClassLoader();
                try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(classLoader);){
                    fs = factory.create(uri);
                }
            }
            if (!ALLOWED_FALLBACK_FILESYSTEMS.contains(uri.getScheme()) && DIRECTLY_SUPPORTED_FILESYSTEM.containsKey(uri.getScheme())) {
                Collection<String> plugins = DIRECTLY_SUPPORTED_FILESYSTEM.get(uri.getScheme());
                throw new UnsupportedFileSystemSchemeException(String.format("Could not find a file system implementation for scheme '%s'. The scheme is directly supported by Flink through the following plugin(s): %s. Please ensure that each plugin resides within its own subfolder within the plugins directory. See https://nightlies.apache.org/flink/flink-docs-stable/docs/deployment/filesystems/plugins/ for more information. If you want to use a Hadoop file system for that scheme, please add the scheme to the configuration fs.allowed-fallback-filesystems. For a full list of supported file systems, please see https://nightlies.apache.org/flink/flink-docs-stable/ops/filesystems/.", uri.getScheme(), String.join((CharSequence)", ", plugins)));
            }
            try {
                fs = FALLBACK_FACTORY.create(uri);
            }
            catch (UnsupportedFileSystemSchemeException e) {
                if (DIRECTLY_SUPPORTED_FILESYSTEM.containsKey(uri.getScheme())) {
                    Collection<String> plugins = DIRECTLY_SUPPORTED_FILESYSTEM.get(uri.getScheme());
                    throw new UnsupportedFileSystemSchemeException(String.format("Could not find a file system implementation for scheme '%s'. File system schemes are supported by Flink through the following plugin(s): %s. No file system to support this scheme could be loaded. Please ensure that each plugin is configured properly and resides within its own subfolder in the plugins directory. See https://nightlies.apache.org/flink/flink-docs-stable/docs/deployment/filesystems/plugins/ for more information.", uri.getScheme(), String.join((CharSequence)", ", plugins)));
                }
                throw new UnsupportedFileSystemSchemeException("Could not find a file system implementation for scheme '" + uri.getScheme() + "'. The scheme is not directly supported by Flink and no Hadoop file system to support this scheme could be loaded. For a full list of supported file systems, please see https://nightlies.apache.org/flink/flink-docs-stable/ops/filesystems/.", e);
            }
            CACHE.put(key, fs);
            FileSystem fileSystem = fs;
            return fileSystem;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static URI getDefaultFsUri() {
        return defaultScheme != null ? defaultScheme : LocalFileSystem.getLocalFsURI();
    }

    @Deprecated
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite ? WriteMode.OVERWRITE : WriteMode.NO_OVERWRITE);
    }

    @Deprecated
    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite ? WriteMode.OVERWRITE : WriteMode.NO_OVERWRITE);
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return 0x2000000L;
    }

    @Override
    public abstract Path getWorkingDirectory();

    @Override
    public abstract Path getHomeDirectory();

    @Override
    public abstract URI getUri();

    @Override
    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    @Override
    public abstract BlockLocation[] getFileBlockLocations(FileStatus var1, long var2, long var4) throws IOException;

    @Override
    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    @Override
    public abstract FSDataInputStream open(Path var1) throws IOException;

    @Override
    public RecoverableWriter createRecoverableWriter() throws IOException {
        return IFileSystem.super.createRecoverableWriter();
    }

    @Override
    @PublicEvolving
    public RecoverableWriter createRecoverableWriter(Map<String, String> conf) throws IOException {
        if (conf == null || conf.isEmpty()) {
            return this.createRecoverableWriter();
        }
        return IFileSystem.super.createRecoverableWriter(conf);
    }

    @Override
    public abstract FileStatus[] listStatus(Path var1) throws IOException;

    @Override
    public boolean exists(Path f) throws IOException {
        return IFileSystem.super.exists(f);
    }

    @Override
    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    @Override
    public abstract boolean mkdirs(Path var1) throws IOException;

    @Override
    public abstract FSDataOutputStream create(Path var1, WriteMode var2) throws IOException;

    @Override
    public abstract boolean rename(Path var1, Path var2) throws IOException;

    @Override
    public abstract boolean isDistributedFS();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean initOutPathLocalFS(Path outPath, WriteMode writeMode, boolean createDirectory) throws IOException {
        if (this.isDistributedFS()) {
            return false;
        }
        try {
            OUTPUT_DIRECTORY_INIT_LOCK.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("The thread was interrupted while trying to initialize the output directory");
        }
        try {
            FileStatus status;
            try {
                status = this.getFileStatus(outPath);
            }
            catch (FileNotFoundException e) {
                status = null;
            }
            if (status != null) {
                switch (writeMode) {
                    case NO_OVERWRITE: {
                        if (status.isDir() && createDirectory) {
                            boolean e = true;
                            return e;
                        }
                        throw new IOException("File or directory " + String.valueOf(outPath) + " already exists. Existing files and directories are not overwritten in " + WriteMode.NO_OVERWRITE.name() + " mode. Use " + WriteMode.OVERWRITE.name() + " mode to overwrite existing files and directories.");
                    }
                    case OVERWRITE: {
                        if (status.isDir()) {
                            if (createDirectory) {
                                boolean e = true;
                                return e;
                            }
                            try {
                                this.delete(outPath, true);
                                break;
                            }
                            catch (IOException e) {
                                throw new IOException("Could not remove existing directory '" + String.valueOf(outPath) + "' to allow overwrite by result file", e);
                            }
                        }
                        try {
                            this.delete(outPath, false);
                            break;
                        }
                        catch (IOException e) {
                            throw new IOException("Could not remove existing file '" + String.valueOf(outPath) + "' to allow overwrite by result file/directory", e);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid write mode: " + String.valueOf((Object)writeMode));
                    }
                }
            }
            if (createDirectory) {
                if (!this.exists(outPath)) {
                    this.mkdirs(outPath);
                }
                try {
                    boolean e = this.getFileStatus(outPath).isDir();
                    return e;
                }
                catch (FileNotFoundException e) {
                    boolean bl = false;
                    OUTPUT_DIRECTORY_INIT_LOCK.unlock();
                    return bl;
                }
            }
            boolean bl = !this.exists(outPath);
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            OUTPUT_DIRECTORY_INIT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initOutPathDistFS(Path outPath, WriteMode writeMode, boolean createDirectory) throws IOException {
        if (!this.isDistributedFS()) {
            return false;
        }
        try {
            OUTPUT_DIRECTORY_INIT_LOCK.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("The thread was interrupted while trying to initialize the output directory");
        }
        try {
            if (this.exists(outPath)) {
                switch (writeMode) {
                    case NO_OVERWRITE: {
                        throw new IOException("File or directory already exists. Existing files and directories are not overwritten in " + WriteMode.NO_OVERWRITE.name() + " mode. Use " + WriteMode.OVERWRITE.name() + " mode to overwrite existing files and directories.");
                    }
                    case OVERWRITE: {
                        try {
                            this.delete(outPath, true);
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid write mode: " + String.valueOf((Object)writeMode));
                    }
                }
            }
            if (createDirectory) {
                try {
                    if (!this.exists(outPath)) {
                        this.mkdirs(outPath);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                boolean bl = this.exists(outPath) && this.getFileStatus(outPath).isDir();
                return bl;
            }
            boolean bl = !this.exists(outPath);
            return bl;
        }
        finally {
            OUTPUT_DIRECTORY_INIT_LOCK.unlock();
        }
    }

    private static List<FileSystemFactory> loadFileSystemFactories(Collection<Supplier<Iterator<FileSystemFactory>>> factoryIteratorsSuppliers) {
        ArrayList<FileSystemFactory> list = new ArrayList<FileSystemFactory>();
        list.add(new LocalFileSystemFactory());
        LOG.debug("Loading extension file systems via services");
        for (Supplier<Iterator<FileSystemFactory>> factoryIteratorsSupplier : factoryIteratorsSuppliers) {
            try {
                FileSystem.addAllFactoriesToList(factoryIteratorsSupplier.get(), list);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM(t);
                LOG.error("Failed to load additional file systems via services", t);
            }
        }
        return Collections.unmodifiableList(list);
    }

    private static void addAllFactoriesToList(Iterator<FileSystemFactory> iter, List<FileSystemFactory> list) {
        while (iter.hasNext()) {
            try {
                FileSystemFactory factory = iter.next();
                list.add(factory);
                LOG.debug("Added file system {}:{}", (Object)factory.getScheme(), (Object)factory.getClass().getSimpleName());
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM(t);
                LOG.error("Failed to load a file system via services", t);
            }
        }
    }

    private static FileSystemFactory loadHadoopFsFactory() {
        Class<FileSystemFactory> factoryClass;
        ClassLoader cl = FileSystem.class.getClassLoader();
        try {
            factoryClass = Class.forName("org.apache.flink.runtime.fs.hdfs.HadoopFsFactory", false, cl).asSubclass(FileSystemFactory.class);
        }
        catch (ClassNotFoundException e) {
            LOG.info("No Flink runtime dependency present. The extended set of supported File Systems via Hadoop is not available.");
            return new UnsupportedSchemeFactory("Flink runtime classes missing in classpath/dependencies.");
        }
        catch (Exception | LinkageError e) {
            LOG.warn("Flink's Hadoop file system factory could not be loaded", e);
            return new UnsupportedSchemeFactory("Flink's Hadoop file system factory could not be loaded", e);
        }
        try {
            Class.forName("org.apache.hadoop.conf.Configuration", false, cl);
            Class.forName("org.apache.hadoop.fs.FileSystem", false, cl);
        }
        catch (ClassNotFoundException e) {
            LOG.info("Hadoop is not in the classpath/dependencies. The extended set of supported File Systems via Hadoop is not available.");
            return new UnsupportedSchemeFactory("Hadoop is not in the classpath/dependencies.");
        }
        try {
            return factoryClass.newInstance();
        }
        catch (Exception | LinkageError e) {
            LOG.warn("Flink's Hadoop file system factory could not be created", e);
            return new UnsupportedSchemeFactory("Flink's Hadoop file system factory could not be created", e);
        }
    }

    @Internal
    public static final class FSKey {
        private final String scheme;
        @Nullable
        private final String authority;

        public FSKey(String scheme, @Nullable String authority) {
            this.scheme = Preconditions.checkNotNull(scheme, "scheme");
            this.authority = authority;
        }

        public FSKey(URI uri) {
            this(uri.getScheme(), uri.getAuthority());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == FSKey.class) {
                FSKey that = (FSKey)obj;
                return this.scheme.equals(that.scheme) && (this.authority == null ? that.authority == null : that.authority != null && this.authority.equals(that.authority));
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.scheme.hashCode() + (this.authority == null ? 17 : this.authority.hashCode());
        }

        public String toString() {
            return this.scheme + "://" + (this.authority != null ? this.authority : "");
        }
    }

    public static enum WriteMode {
        NO_OVERWRITE,
        OVERWRITE;

    }
}

