/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.client.deployment.application.EntryClassInformationProvider;
import org.apache.flink.client.deployment.application.JarManifestParser;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class FromClasspathEntryClassInformationProvider
implements EntryClassInformationProvider {
    private final String jobClassName;

    public static FromClasspathEntryClassInformationProvider create(String jobClassName, Iterable<URL> classpath) throws IOException, FlinkException {
        Preconditions.checkNotNull(jobClassName, "No job class name passed.");
        Preconditions.checkNotNull(classpath, "No classpath passed.");
        return new FromClasspathEntryClassInformationProvider(jobClassName);
    }

    public static FromClasspathEntryClassInformationProvider createFromClasspath(Iterable<URL> classpath) throws IOException, FlinkException {
        return new FromClasspathEntryClassInformationProvider(FromClasspathEntryClassInformationProvider.extractJobClassFromUrlClasspath(classpath));
    }

    public static FromClasspathEntryClassInformationProvider createFromSystemClasspath() throws IOException, FlinkException {
        return new FromClasspathEntryClassInformationProvider(FromClasspathEntryClassInformationProvider.extractJobClassFromSystemClasspath());
    }

    public static FromClasspathEntryClassInformationProvider createWithJobClassAssumingOnSystemClasspath(String jobClassName) {
        return new FromClasspathEntryClassInformationProvider(jobClassName);
    }

    private FromClasspathEntryClassInformationProvider(String jobClassName) {
        this.jobClassName = Preconditions.checkNotNull(jobClassName, "No job class name set.");
    }

    @Override
    public Optional<File> getJarFile() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getJobClassName() {
        return Optional.of(this.jobClassName);
    }

    @VisibleForTesting
    static Iterable<File> extractSystemClasspath() {
        String classpathPropertyValue = System.getProperty("java.class.path", "");
        String pathSeparator = System.getProperty("path.separator", ":");
        return Arrays.stream(classpathPropertyValue.split(pathSeparator)).filter(entry -> !StringUtils.isNullOrWhitespaceOnly(entry)).map(File::new).filter(File::isFile).filter(f -> FromClasspathEntryClassInformationProvider.isJarFilename(f.getName())).collect(Collectors.toList());
    }

    private static String extractJobClassFromSystemClasspath() throws FlinkException, IOException {
        return FromClasspathEntryClassInformationProvider.extractJobClassNameFromFileClasspath(FromClasspathEntryClassInformationProvider.extractSystemClasspath());
    }

    private static String extractJobClassFromUrlClasspath(Iterable<URL> classpath) throws IOException, FlinkException {
        List<File> jarFilesFromClasspath = StreamSupport.stream(classpath.spliterator(), false).map(url -> new File(url.getFile())).filter(f -> FromClasspathEntryClassInformationProvider.isJarFilename(f.getName())).collect(Collectors.toList());
        return FromClasspathEntryClassInformationProvider.extractJobClassNameFromFileClasspath(jarFilesFromClasspath);
    }

    private static String extractJobClassNameFromFileClasspath(Iterable<File> classpath) throws FlinkException, IOException {
        try {
            return JarManifestParser.findOnlyEntryClass(classpath).getEntryClass();
        }
        catch (NoSuchElementException e) {
            throw new FlinkException("No JAR found on classpath. Please provide a JAR explicitly.", e);
        }
        catch (IllegalArgumentException e) {
            throw new FlinkException("Multiple JAR archives with entry classes found on classpath. Please provide an entry class name.", e);
        }
    }

    private static boolean isJarFilename(String filename) {
        return filename.endsWith(".jar");
    }
}

