/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.dag;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.attribute.Attribute;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class Transformation<T> {
    public static final int UPPER_BOUND_MAX_PARALLELISM = 32768;
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    private boolean parallelismConfigured;
    @Nullable
    private Map<String, String> additionalMetricVariables;
    protected final int id;
    protected String name;
    protected String description;
    protected TypeInformation<T> outputType;
    protected boolean typeUsed;
    private int parallelism;
    private int maxParallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private final Map<ManagedMemoryUseCase, Integer> managedMemoryOperatorScopeUseCaseWeights = new EnumMap<ManagedMemoryUseCase, Integer>(ManagedMemoryUseCase.class);
    private final Map<Transformation<T>, List<Transformation<?>>> predecessorsCache = new HashMap();
    private final Set<ManagedMemoryUseCase> managedMemorySlotScopeUseCases = new HashSet<ManagedMemoryUseCase>();
    private String uid;
    private String userProvidedNodeHash;
    protected long bufferTimeout = -1L;
    private Optional<SlotSharingGroup> slotSharingGroup;
    @Nullable
    private String coLocationGroupKey;
    private Attribute attribute = new Attribute.Builder().build();

    public static int getNewNodeId() {
        return ID_COUNTER.incrementAndGet();
    }

    public Transformation(String name, TypeInformation<T> outputType, int parallelism) {
        this(name, outputType, parallelism, true);
    }

    public Transformation(String name, TypeInformation<T> outputType, int parallelism, boolean parallelismConfigured) {
        this.id = Transformation.getNewNodeId();
        this.name = Preconditions.checkNotNull(name);
        this.outputType = outputType;
        this.parallelism = parallelism;
        this.slotSharingGroup = Optional.empty();
        this.parallelismConfigured = parallelismConfigured && parallelism != -1;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    Map<Transformation<T>, List<Transformation<?>>> getPredecessorsCache() {
        return this.predecessorsCache;
    }

    public void setDescription(String description) {
        this.description = Preconditions.checkNotNull(description);
    }

    public String getDescription() {
        return this.description;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.setParallelism(parallelism, true);
    }

    public void setParallelism(int parallelism, boolean parallelismConfigured) {
        OperatorValidationUtils.validateParallelism(parallelism);
        this.parallelism = parallelism;
        this.parallelismConfigured = parallelismConfigured && parallelism != -1;
    }

    public boolean isParallelismConfigured() {
        return this.parallelismConfigured;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        OperatorValidationUtils.validateMaxParallelism(maxParallelism, 32768);
        this.maxParallelism = maxParallelism;
    }

    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        OperatorValidationUtils.validateMinAndPreferredResources(minResources, preferredResources);
        this.minResources = minResources;
        this.preferredResources = preferredResources;
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public Optional<Integer> declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase managedMemoryUseCase, int weight) {
        Preconditions.checkNotNull(managedMemoryUseCase);
        Preconditions.checkArgument(managedMemoryUseCase.scope == ManagedMemoryUseCase.Scope.OPERATOR, "Use case is not operator scope.");
        Preconditions.checkArgument(weight > 0, "Weights for operator scope use cases must be greater than 0.");
        return Optional.ofNullable(this.managedMemoryOperatorScopeUseCaseWeights.put(managedMemoryUseCase, weight));
    }

    public void declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase managedMemoryUseCase) {
        Preconditions.checkNotNull(managedMemoryUseCase);
        Preconditions.checkArgument(managedMemoryUseCase.scope == ManagedMemoryUseCase.Scope.SLOT);
        this.managedMemorySlotScopeUseCases.add(managedMemoryUseCase);
    }

    protected void updateManagedMemoryStateBackendUseCase(boolean hasStateBackend) {
        if (hasStateBackend) {
            this.managedMemorySlotScopeUseCases.add(ManagedMemoryUseCase.STATE_BACKEND);
        } else {
            this.managedMemorySlotScopeUseCases.remove((Object)ManagedMemoryUseCase.STATE_BACKEND);
        }
    }

    public Map<ManagedMemoryUseCase, Integer> getManagedMemoryOperatorScopeUseCaseWeights() {
        return Collections.unmodifiableMap(this.managedMemoryOperatorScopeUseCaseWeights);
    }

    public Set<ManagedMemoryUseCase> getManagedMemorySlotScopeUseCases() {
        return Collections.unmodifiableSet(this.managedMemorySlotScopeUseCases);
    }

    public void setUidHash(String uidHash) {
        Preconditions.checkNotNull(uidHash);
        Preconditions.checkArgument(uidHash.matches("^[0-9A-Fa-f]{32}$"), "Node hash must be a 32 character String that describes a hex code. Found: " + uidHash);
        this.userProvidedNodeHash = uidHash;
    }

    public String getUserProvidedNodeHash() {
        return this.userProvidedNodeHash;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    @Nullable
    public Map<String, String> getAdditionalMetricVariables() {
        return this.additionalMetricVariables;
    }

    public Transformation<T> addMetricVariable(String key, String value) {
        if (this.additionalMetricVariables == null) {
            this.additionalMetricVariables = new HashMap<String, String>();
        }
        this.additionalMetricVariables.put(key, value);
        return this;
    }

    public Optional<SlotSharingGroup> getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public void setSlotSharingGroup(String slotSharingGroupName) {
        this.slotSharingGroup = Optional.of(SlotSharingGroup.newBuilder(slotSharingGroupName).build());
    }

    public void setSlotSharingGroup(SlotSharingGroup slotSharingGroup) {
        this.slotSharingGroup = Optional.of(slotSharingGroup);
    }

    public void setCoLocationGroupKey(@Nullable String coLocationGroupKey) {
        this.coLocationGroupKey = coLocationGroupKey;
    }

    @Nullable
    public String getCoLocationGroupKey() {
        return this.coLocationGroupKey;
    }

    public void setOutputType(TypeInformation<T> outputType) {
        if (this.typeUsed) {
            throw new IllegalStateException("TypeInformation cannot be filled in for the type after it has been used. Please make sure that the type info hints are the first call after the transformation function, before any access to types or semantic properties, etc.");
        }
        this.outputType = outputType;
    }

    public TypeInformation<T> getOutputType() {
        if (this.outputType instanceof MissingTypeInfo) {
            MissingTypeInfo typeInfo = (MissingTypeInfo)this.outputType;
            throw new InvalidTypesException("The return type of function '" + typeInfo.getFunctionName() + "' could not be determined automatically, due to type erasure. You can give type information hints by using the returns(...) method on the result of the transformation call, or by letting your function implement the 'ResultTypeQueryable' interface.", typeInfo.getTypeException());
        }
        this.typeUsed = true;
        return this.outputType;
    }

    public void setBufferTimeout(long bufferTimeout) {
        Preconditions.checkArgument(bufferTimeout >= -1L);
        this.bufferTimeout = bufferTimeout;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    protected abstract List<Transformation<?>> getTransitivePredecessorsInternal();

    public final List<Transformation<?>> getTransitivePredecessors() {
        return this.predecessorsCache.computeIfAbsent(this, key -> this.getTransitivePredecessorsInternal());
    }

    public abstract List<Transformation<?>> getInputs();

    public void enableAsyncState() {
        throw new UnsupportedOperationException("The transformation does not support async state, or you are enabling the async state without a keyed context (not behind a keyBy()).");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", name='" + this.name + "', outputType=" + String.valueOf(this.outputType) + ", parallelism=" + this.parallelism + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transformation)) {
            return false;
        }
        Transformation that = (Transformation)o;
        return Objects.equals(this.bufferTimeout, that.bufferTimeout) && Objects.equals(this.id, that.id) && Objects.equals(this.additionalMetricVariables, that.additionalMetricVariables) && Objects.equals(this.parallelism, that.parallelism) && Objects.equals(this.name, that.name) && Objects.equals(this.outputType, that.outputType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.outputType, this.parallelism, this.bufferTimeout);
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }
}

