/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.watermark;

import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.watermark.LongWatermark;
import org.apache.flink.api.common.watermark.WatermarkCombinationPolicy;
import org.apache.flink.api.common.watermark.WatermarkDeclaration;
import org.apache.flink.api.common.watermark.WatermarkHandlingStrategy;

@Experimental
public class LongWatermarkDeclaration
implements WatermarkDeclaration {
    protected static final long serialVersionUID = 1L;
    protected final String identifier;
    protected final WatermarkCombinationPolicy combinationPolicy;
    protected final WatermarkHandlingStrategy defaultHandlingStrategy;

    public LongWatermarkDeclaration(String identifier, WatermarkCombinationPolicy combinationPolicy, WatermarkHandlingStrategy defaultHandlingStrategy) {
        this.identifier = identifier;
        this.combinationPolicy = combinationPolicy;
        this.defaultHandlingStrategy = defaultHandlingStrategy;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public LongWatermark newWatermark(long val) {
        return new LongWatermark(val, this.identifier);
    }

    public WatermarkCombinationPolicy getCombinationPolicy() {
        return this.combinationPolicy;
    }

    public WatermarkHandlingStrategy getDefaultHandlingStrategy() {
        return this.defaultHandlingStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongWatermarkDeclaration that = (LongWatermarkDeclaration)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.combinationPolicy, that.combinationPolicy) && this.defaultHandlingStrategy == that.defaultHandlingStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.combinationPolicy, this.defaultHandlingStrategy});
    }

    public String toString() {
        return "LongWatermarkDeclaration{identifier='" + this.identifier + "', combinationPolicy=" + String.valueOf(this.combinationPolicy) + ", defaultHandlingStrategy=" + String.valueOf((Object)this.defaultHandlingStrategy) + "}";
    }
}

