/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.SetSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class SetSerializer<T>
extends TypeSerializer<Set<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> elementSerializer;

    public SetSerializer(TypeSerializer<T> elementSerializer) {
        this.elementSerializer = Preconditions.checkNotNull(elementSerializer);
    }

    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Set<T>> duplicate() {
        TypeSerializer<T> duplicateElement = this.elementSerializer.duplicate();
        return duplicateElement == this.elementSerializer ? this : new SetSerializer<T>(duplicateElement);
    }

    @Override
    public Set<T> createInstance() {
        return new HashSet(0);
    }

    @Override
    public Set<T> copy(Set<T> from) {
        HashSet<Object> newSet = new HashSet<Object>(from.size());
        for (T element : from) {
            Object newElement = element == null ? null : (Object)this.elementSerializer.copy(element);
            newSet.add(newElement);
        }
        return newSet;
    }

    @Override
    public Set<T> copy(Set<T> from, Set<T> reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Set<T> set, DataOutputView target) throws IOException {
        int size = set.size();
        target.writeInt(size);
        for (T element : set) {
            if (element == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.elementSerializer.serialize(element, target);
        }
    }

    @Override
    public Set<T> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        HashSet<Object> set = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            boolean isNull = source.readBoolean();
            Object element = isNull ? null : (Object)this.elementSerializer.deserialize(source);
            set.add(element);
        }
        return set;
    }

    @Override
    public Set<T> deserialize(Set<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int num = source.readInt();
        target.writeInt(num);
        for (int i = 0; i < num; ++i) {
            boolean isNull = source.readBoolean();
            target.writeBoolean(isNull);
            if (isNull) continue;
            this.elementSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.elementSerializer.equals(((SetSerializer)obj).elementSerializer);
    }

    @Override
    public int hashCode() {
        return this.elementSerializer.hashCode();
    }

    @Override
    public TypeSerializerSnapshot<Set<T>> snapshotConfiguration() {
        return new SetSerializerSnapshot(this);
    }
}

