/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.NonSerializableUserCodeException;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.util.Preconditions;

@Internal
public class UserCodeObjectWrapper<T>
implements UserCodeWrapper<T> {
    private static final long serialVersionUID = 1L;
    private final T userCodeObject;

    public UserCodeObjectWrapper(T userCodeObject) {
        Preconditions.checkNotNull(userCodeObject, "The user code object may not be null.");
        Preconditions.checkArgument(userCodeObject instanceof Serializable, "User code object is not serializable: " + userCodeObject.getClass().getName());
        this.userCodeObject = userCodeObject;
        T current = userCodeObject;
        try {
            while (null != current) {
                Object newCurrent = null;
                boolean hasCustomSerialization = false;
                Method customSerializer = null;
                Method customDeserializer = null;
                try {
                    customSerializer = current.getClass().getDeclaredMethod("writeObject", ObjectOutputStream.class);
                    customDeserializer = current.getClass().getDeclaredMethod("readObject", ObjectInputStream.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (customSerializer != null && customDeserializer != null) {
                    hasCustomSerialization = true;
                }
                for (Field f : current.getClass().getDeclaredFields()) {
                    Object fieldContents;
                    f.setAccessible(true);
                    if (f.getName().contains("$outer")) {
                        newCurrent = f.get(current);
                    }
                    if (hasCustomSerialization || Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || (fieldContents = f.get(current)) == null || fieldContents instanceof Serializable) continue;
                    throw new NonSerializableUserCodeException("User-defined object " + String.valueOf(userCodeObject) + " (" + userCodeObject.getClass().getName() + ") contains non-serializable field " + f.getName() + " = " + String.valueOf(f.get(current)));
                }
                current = newCurrent;
            }
        }
        catch (NonSerializableUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access the fields of the user defined class while checking for serializability.", e);
        }
    }

    @Override
    public T getUserCodeObject(Class<? super T> superClass, ClassLoader cl) {
        return this.userCodeObject;
    }

    @Override
    public T getUserCodeObject() {
        return this.userCodeObject;
    }

    @Override
    public <A extends Annotation> A getUserCodeAnnotation(Class<A> annotationClass) {
        return this.userCodeObject.getClass().getAnnotation(annotationClass);
    }

    @Override
    public Class<? extends T> getUserCodeClass() {
        return this.userCodeObject.getClass();
    }

    @Override
    public boolean hasObject() {
        return true;
    }
}

