/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.factories.AmbiguousTableFactoryException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.NoMatchingTableFactoryException;
import org.apache.flink.table.legacy.descriptors.Descriptor;
import org.apache.flink.table.legacy.factories.TableFactory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Internal
public class TableFactoryService {
    public static final String FORMAT = "format";
    public static final String FORMAT_TYPE = "format.type";
    public static final String FORMAT_PROPERTY_VERSION = "format.property-version";
    public static final String FORMAT_DERIVE_SCHEMA = "format.derive-schema";
    private static final Logger LOG = LoggerFactory.getLogger(TableFactoryService.class);

    public static <T extends TableFactory> T find(Class<T> factoryClass, Descriptor descriptor) {
        Preconditions.checkNotNull(descriptor);
        return TableFactoryService.findSingleInternal(factoryClass, descriptor.toProperties(), Optional.empty());
    }

    public static <T extends TableFactory> T find(Class<T> factoryClass, Descriptor descriptor, ClassLoader classLoader) {
        Preconditions.checkNotNull(descriptor);
        Preconditions.checkNotNull(classLoader);
        return TableFactoryService.findSingleInternal(factoryClass, descriptor.toProperties(), Optional.of(classLoader));
    }

    public static <T extends TableFactory> T find(Class<T> factoryClass, Map<String, String> propertyMap) {
        return TableFactoryService.findSingleInternal(factoryClass, propertyMap, Optional.empty());
    }

    public static <T extends TableFactory> T find(Class<T> factoryClass, Map<String, String> propertyMap, ClassLoader classLoader) {
        Preconditions.checkNotNull(classLoader);
        return TableFactoryService.findSingleInternal(factoryClass, propertyMap, Optional.of(classLoader));
    }

    public static <T extends TableFactory> List<T> findAll(Class<T> factoryClass, Map<String, String> propertyMap) {
        return TableFactoryService.findAllInternal(factoryClass, propertyMap, Optional.empty());
    }

    private static <T extends TableFactory> T findSingleInternal(Class<T> factoryClass, Map<String, String> properties, Optional<ClassLoader> classLoader) {
        List<TableFactory> tableFactories = TableFactoryService.discoverFactories(classLoader);
        List<T> filtered = TableFactoryService.filter(tableFactories, factoryClass, properties);
        if (filtered.size() > 1) {
            throw new AmbiguousTableFactoryException(filtered, factoryClass, tableFactories, properties);
        }
        return (T)((TableFactory)filtered.get(0));
    }

    private static <T extends TableFactory> List<T> findAllInternal(Class<T> factoryClass, Map<String, String> properties, Optional<ClassLoader> classLoader) {
        List<TableFactory> tableFactories = TableFactoryService.discoverFactories(classLoader);
        return TableFactoryService.filter(tableFactories, factoryClass, properties);
    }

    private static <T extends TableFactory> List<T> filter(List<TableFactory> foundFactories, Class<T> factoryClass, Map<String, String> properties) {
        Preconditions.checkNotNull(factoryClass);
        Preconditions.checkNotNull(properties);
        List<T> classFactories = TableFactoryService.filterByFactoryClass(factoryClass, properties, foundFactories);
        List<T> contextFactories = TableFactoryService.filterByContext(factoryClass, properties, classFactories);
        return TableFactoryService.filterBySupportedProperties(factoryClass, properties, classFactories, contextFactories);
    }

    private static List<TableFactory> discoverFactories(Optional<ClassLoader> classLoader) {
        try {
            LinkedList<TableFactory> result = new LinkedList<TableFactory>();
            ClassLoader cl = classLoader.orElse(Thread.currentThread().getContextClassLoader());
            ServiceLoader.load(TableFactory.class, cl).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for table factories.", (Throwable)e);
            throw new TableException("Could not load service provider for table factories.", e);
        }
    }

    private static <T> List<T> filterByFactoryClass(Class<T> factoryClass, Map<String, String> properties, List<TableFactory> foundFactories) {
        List classFactories = foundFactories.stream().filter(p -> factoryClass.isAssignableFrom(p.getClass())).collect(Collectors.toList());
        if (classFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException(String.format("No factory implements '%s'.", factoryClass.getCanonicalName()), factoryClass, foundFactories, properties);
        }
        return classFactories;
    }

    private static <T extends TableFactory> List<T> filterByContext(Class<T> factoryClass, Map<String, String> properties, List<T> classFactories) {
        ArrayList<TableFactory> matchingFactories = new ArrayList<TableFactory>();
        ContextBestMatched<TableFactory> bestMatched = null;
        for (TableFactory factory : classFactories) {
            Map<String, String> requestedContext = TableFactoryService.normalizeContext(factory);
            HashMap<String, String> plainContext = new HashMap<String, String>(requestedContext);
            plainContext.remove("connector.property-version");
            plainContext.remove(FORMAT_PROPERTY_VERSION);
            plainContext.remove(FactoryUtil.PROPERTY_VERSION.key());
            HashMap<String, Tuple2<String, String>> mismatchedProperties = new HashMap<String, Tuple2<String, String>>();
            HashMap<String, String> missingProperties = new HashMap<String, String>();
            for (Map.Entry e2 : plainContext.entrySet()) {
                if (properties.containsKey(e2.getKey())) {
                    String fromProperties = properties.get(e2.getKey());
                    if (Objects.equals(fromProperties, e2.getValue())) continue;
                    mismatchedProperties.put((String)e2.getKey(), new Tuple2<String, String>((String)e2.getValue(), fromProperties));
                    continue;
                }
                missingProperties.put((String)e2.getKey(), (String)e2.getValue());
            }
            int matchedSize = plainContext.size() - mismatchedProperties.size() - missingProperties.size();
            if (matchedSize == plainContext.size()) {
                matchingFactories.add(factory);
                continue;
            }
            if (bestMatched != null && matchedSize <= bestMatched.matchedSize) continue;
            bestMatched = new ContextBestMatched<TableFactory>(factory, matchedSize, mismatchedProperties, missingProperties);
        }
        if (matchingFactories.isEmpty()) {
            String bestMatchedMessage = null;
            if (bestMatched != null && bestMatched.matchedSize > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(bestMatched.factory.getClass().getName());
                if (bestMatched.missingProperties.size() > 0) {
                    builder.append("\nMissing properties:");
                    bestMatched.missingProperties.forEach((k, v) -> builder.append("\n").append((String)k).append("=").append((String)v));
                }
                if (bestMatched.mismatchedProperties.size() > 0) {
                    builder.append("\nMismatched properties:");
                    bestMatched.mismatchedProperties.entrySet().stream().filter(e -> ((Tuple2)e.getValue()).f1 != null).forEach(e -> builder.append(String.format("\n'%s' expects '%s', but is '%s'", e.getKey(), ((Tuple2)e.getValue()).f0, ((Tuple2)e.getValue()).f1)));
                }
                bestMatchedMessage = builder.toString();
            }
            throw new NoMatchingTableFactoryException("Required context properties mismatch.", bestMatchedMessage, factoryClass, classFactories, properties);
        }
        return matchingFactories;
    }

    private static Map<String, String> normalizeContext(TableFactory factory) {
        Map<String, String> requiredContext = factory.requiredContext();
        if (requiredContext == null) {
            throw new TableException(String.format("Required context of factory '%s' must not be null.", factory.getClass().getName()));
        }
        return requiredContext.keySet().stream().collect(Collectors.toMap(String::toLowerCase, requiredContext::get));
    }

    private static <T extends TableFactory> List<T> filterBySupportedProperties(Class<T> factoryClass, Map<String, String> properties, List<T> classFactories, List<T> contextFactories) {
        LinkedList plainGivenKeys = new LinkedList();
        properties.keySet().forEach(k -> {
            String key = k.replaceAll(".\\d+", ".#");
            if (!plainGivenKeys.contains(key)) {
                plainGivenKeys.add(key);
            }
        });
        LinkedList<TableFactory> supportedFactories = new LinkedList<TableFactory>();
        Tuple2 bestMatched = null;
        for (TableFactory factory : contextFactories) {
            Set<String> requiredContextKeys = TableFactoryService.normalizeContext(factory).keySet();
            Tuple2<List<String>, List<String>> tuple2 = TableFactoryService.normalizeSupportedProperties(factory);
            List givenContextFreeKeys = plainGivenKeys.stream().filter(p -> !requiredContextKeys.contains(p)).collect(Collectors.toList());
            boolean allTrue = true;
            ArrayList<String> unsupportedKeys = new ArrayList<String>();
            for (String k2 : givenContextFreeKeys) {
                if (((List)tuple2.f0).contains(k2)) continue;
                if (((List)tuple2.f1).stream().anyMatch(k2::startsWith)) continue;
                allTrue = false;
                unsupportedKeys.add(k2);
            }
            if (allTrue) {
                supportedFactories.add(factory);
                continue;
            }
            if (bestMatched != null && unsupportedKeys.size() >= ((List)bestMatched.f1).size()) continue;
            bestMatched = new Tuple2(factory, unsupportedKeys);
        }
        if (supportedFactories.isEmpty()) {
            String bestMatchedMessage = null;
            if (bestMatched != null) {
                bestMatchedMessage = String.format("%s\nUnsupported property keys:\n%s", ((TableFactory)bestMatched.f0).getClass().getName(), String.join((CharSequence)"\n", (Iterable)bestMatched.f1));
            }
            throw new NoMatchingTableFactoryException("No factory supports all properties.", bestMatchedMessage, factoryClass, classFactories, properties);
        }
        return supportedFactories;
    }

    private static Tuple2<List<String>, List<String>> normalizeSupportedProperties(TableFactory factory) {
        List<String> supportedProperties = factory.supportedProperties();
        if (supportedProperties == null) {
            throw new TableException(String.format("Supported properties of factory '%s' must not be null.", factory.getClass().getName()));
        }
        List<String> supportedKeys = supportedProperties.stream().map(String::toLowerCase).collect(Collectors.toList());
        List<String> wildcards = TableFactoryService.extractWildcardPrefixes(supportedKeys);
        return Tuple2.of(supportedKeys, wildcards);
    }

    private static List<String> extractWildcardPrefixes(List<String> propertyKeys) {
        return propertyKeys.stream().filter(p -> p.endsWith("*")).map(s -> s.substring(0, s.length() - 1)).collect(Collectors.toList());
    }

    private static class ContextBestMatched<T extends TableFactory> {
        private final T factory;
        private final int matchedSize;
        private final Map<String, Tuple2<String, String>> mismatchedProperties;
        private final Map<String, String> missingProperties;

        private ContextBestMatched(T factory, int matchedSize, Map<String, Tuple2<String, String>> mismatchedProperties, Map<String, String> missingProperties) {
            this.factory = factory;
            this.matchedSize = matchedSize;
            this.mismatchedProperties = mismatchedProperties;
            this.missingProperties = missingProperties;
        }
    }
}

