/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.runtime.state.ttl.AbstractTtlDecorator;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;

public class TtlReduceFunction<T>
extends AbstractTtlDecorator<ReduceFunction<T>>
implements ReduceFunction<TtlValue<T>> {
    public TtlReduceFunction(ReduceFunction<T> originalReduceFunction, StateTtlConfig config, TtlTimeProvider timeProvider) {
        super(originalReduceFunction, config, timeProvider);
    }

    @Override
    public TtlValue<T> reduce(TtlValue<T> value1, TtlValue<T> value2) throws Exception {
        T userValue1 = this.getUnexpired(value1);
        T userValue2 = this.getUnexpired(value2);
        if (userValue1 != null && userValue2 != null) {
            return this.wrapWithTs(((ReduceFunction)this.original).reduce(userValue1, userValue2));
        }
        if (userValue1 != null) {
            return this.rewrapWithNewTs(value1);
        }
        if (userValue2 != null) {
            return this.rewrapWithNewTs(value2);
        }
        return null;
    }
}

