/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.MetricsTrackingAggregatingState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingListState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingMapState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingReducingState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingValueState;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.SupplierWithException;

public class MetricsTrackingStateFactory<K, N, V, S extends State, IS extends InternalKvState<K, N, ?>> {
    private final InternalKvState<K, N, ?> kvState;
    private final StateDescriptor<S, V> stateDescriptor;
    private final LatencyTrackingStateConfig latencyTrackingStateConfig;
    private final SizeTrackingStateConfig sizeTrackingStateConfig;
    private final Map<StateDescriptor.Type, SupplierWithException<IS, Exception>> stateFactories;
    private final KeyedStateBackend keyedStateBackend;

    private MetricsTrackingStateFactory(InternalKvState<K, N, ?> kvState, KeyedStateBackend<K> keyedStateBackend, StateDescriptor<S, V> stateDescriptor, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) {
        this.kvState = kvState;
        this.keyedStateBackend = keyedStateBackend;
        this.stateDescriptor = stateDescriptor;
        this.latencyTrackingStateConfig = latencyTrackingStateConfig;
        this.sizeTrackingStateConfig = sizeTrackingStateConfig;
        this.stateFactories = this.createStateFactories();
    }

    public static <K, N, V, S extends State> InternalKvState<K, N, ?> createStateAndWrapWithMetricsTrackingIfEnabled(InternalKvState<K, N, ?> kvState, KeyedStateBackend<K> keyedStateBackend, StateDescriptor<S, V> stateDescriptor, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) throws Exception {
        if (latencyTrackingStateConfig.isEnabled() || sizeTrackingStateConfig.isEnabled()) {
            return new MetricsTrackingStateFactory(kvState, keyedStateBackend, stateDescriptor, latencyTrackingStateConfig, sizeTrackingStateConfig).createState();
        }
        return kvState;
    }

    private Map<StateDescriptor.Type, SupplierWithException<IS, Exception>> createStateFactories() {
        return Stream.of(Tuple2.of(StateDescriptor.Type.VALUE, this::createValueState), Tuple2.of(StateDescriptor.Type.LIST, this::createListState), Tuple2.of(StateDescriptor.Type.MAP, this::createMapState), Tuple2.of(StateDescriptor.Type.REDUCING, this::createReducingState), Tuple2.of(StateDescriptor.Type.AGGREGATING, this::createAggregatingState)).collect(Collectors.toMap(t -> (StateDescriptor.Type)((Object)((Object)t.f0)), t -> (SupplierWithException)t.f1));
    }

    private IS createState() throws Exception {
        SupplierWithException<IS, Exception> stateFactory = this.stateFactories.get((Object)this.stateDescriptor.getType());
        if (stateFactory == null) {
            String message = String.format("State %s is not supported by %s", this.stateDescriptor.getClass(), MetricsTrackingStateFactory.class);
            throw new FlinkRuntimeException(message);
        }
        return (IS)((InternalKvState)stateFactory.get());
    }

    private IS createValueState() {
        return (IS)new MetricsTrackingValueState(this.stateDescriptor.getName(), (InternalValueState)this.kvState, this.keyedStateBackend, this.latencyTrackingStateConfig, this.sizeTrackingStateConfig);
    }

    private IS createListState() {
        return (IS)new MetricsTrackingListState(this.stateDescriptor.getName(), (InternalListState)this.kvState, this.keyedStateBackend, this.latencyTrackingStateConfig, this.sizeTrackingStateConfig);
    }

    private <UK, UV> IS createMapState() {
        return (IS)new MetricsTrackingMapState(this.stateDescriptor.getName(), (InternalMapState)this.kvState, this.keyedStateBackend, this.latencyTrackingStateConfig, this.sizeTrackingStateConfig);
    }

    private IS createReducingState() {
        return (IS)new MetricsTrackingReducingState(this.stateDescriptor.getName(), (InternalReducingState)this.kvState, this.keyedStateBackend, this.latencyTrackingStateConfig, this.sizeTrackingStateConfig);
    }

    private <IN, SV, OUT> IS createAggregatingState() {
        return (IS)new MetricsTrackingAggregatingState(this.stateDescriptor.getName(), (InternalAggregatingState)this.kvState, this.keyedStateBackend, this.latencyTrackingStateConfig, this.sizeTrackingStateConfig);
    }
}

