/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.metrics.AbstractMetricsTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateMetricBase;

class MetricsTrackingListState<K, N, T>
extends AbstractMetricsTrackState<K, N, List<T>, InternalListState<K, N, T>, ListStateMetrics>
implements InternalListState<K, N, T> {
    private TypeSerializer<T> elementSerializer;

    MetricsTrackingListState(String stateName, InternalListState<K, N, T> original, KeyedStateBackend<K> keyedStateBackend, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) {
        super(original, keyedStateBackend, latencyTrackingStateConfig.isEnabled() ? new ListStateMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()) : null, sizeTrackingStateConfig.isEnabled() ? new ListStateMetrics(stateName, sizeTrackingStateConfig.getMetricGroup(), sizeTrackingStateConfig.getSampleInterval(), sizeTrackingStateConfig.getHistorySize(), sizeTrackingStateConfig.isStateNameAsVariable()) : null);
        if (this.valueSerializer != null) {
            this.elementSerializer = ((ListSerializer)this.valueSerializer).getElementSerializer().duplicate();
        }
    }

    @Override
    public Iterable<T> get() throws Exception {
        Iterable result = this.latencyTrackingStateMetric != null && ((ListStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnGet() ? this.trackLatencyWithException(() -> (Iterable)((InternalListState)this.original).get(), "listStateGetLatency") : (Iterable)((InternalListState)this.original).get();
        if (this.sizeTrackingStateMetric != null && ((ListStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnGet()) {
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateGetKeySize", super.sizeOfKey());
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateGetValueSize", this.sizeOfValueList(result));
        }
        return result;
    }

    @Override
    public void add(T value) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((ListStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnAdd()) {
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateAddKeySize", super.sizeOfKey());
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateAddValueSize", this.sizeOfValueList(Collections.singletonList(value)));
        }
        if (this.latencyTrackingStateMetric != null && ((ListStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnAdd()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).add(value), "listStateAddLatency");
        } else {
            ((InternalListState)this.original).add(value);
        }
    }

    @Override
    public List<T> getInternal() throws Exception {
        return (List)((InternalListState)this.original).getInternal();
    }

    @Override
    public void updateInternal(List<T> valueToStore) throws Exception {
        ((InternalListState)this.original).updateInternal(valueToStore);
    }

    @Override
    public void update(List<T> values) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((ListStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnUpdate()) {
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateUpdateKeySize", super.sizeOfKey());
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateUpdateValueSize", this.sizeOfValueList(values));
        }
        if (this.latencyTrackingStateMetric != null && ((ListStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnUpdate()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).update(values), "listStateUpdateLatency");
        } else {
            ((InternalListState)this.original).update(values);
        }
    }

    @Override
    public void addAll(List<T> values) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((ListStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnAddAll()) {
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateAddAllKeySize", super.sizeOfKey());
            ((ListStateMetrics)this.sizeTrackingStateMetric).updateMetrics("listStateAddAllValueSize", this.sizeOfValueList(values));
        }
        if (this.latencyTrackingStateMetric != null && ((ListStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnAddAll()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).addAll(values), "listStateAddAllLatency");
        } else {
            ((InternalListState)this.original).addAll(values);
        }
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (this.latencyTrackingStateMetric != null && ((ListStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnMergeNamespace()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).mergeNamespaces(target, sources), "listStateMergeNamespacesLatency");
        } else {
            ((InternalListState)this.original).mergeNamespaces(target, sources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long sizeOfValueList(Iterable<T> valueList) throws IOException {
        if (this.elementSerializer == null || valueList == null) {
            return 0L;
        }
        long totalSize = 0L;
        for (T value : valueList) {
            if (value == null) continue;
            if (this.elementSerializer.getLength() == -1) {
                try {
                    this.elementSerializer.serialize(value, this.outputSerializer);
                    totalSize += (long)this.outputSerializer.length();
                    continue;
                }
                finally {
                    this.outputSerializer.clear();
                    continue;
                }
            }
            totalSize += (long)this.elementSerializer.getLength();
        }
        return totalSize;
    }

    static class ListStateMetrics
    extends StateMetricBase {
        private static final String LIST_STATE_GET_LATENCY = "listStateGetLatency";
        private static final String LIST_STATE_ADD_LATENCY = "listStateAddLatency";
        private static final String LIST_STATE_ADD_ALL_LATENCY = "listStateAddAllLatency";
        private static final String LIST_STATE_UPDATE_LATENCY = "listStateUpdateLatency";
        private static final String LIST_STATE_MERGE_NAMESPACES_LATENCY = "listStateMergeNamespacesLatency";
        private static final String LIST_STATE_GET_KEY_SIZE = "listStateGetKeySize";
        private static final String LIST_STATE_GET_VALUE_SIZE = "listStateGetValueSize";
        private static final String LIST_STATE_ADD_KEY_SIZE = "listStateAddKeySize";
        private static final String LIST_STATE_ADD_VALUE_SIZE = "listStateAddValueSize";
        private static final String LIST_STATE_ADD_ALL_KEY_SIZE = "listStateAddAllKeySize";
        private static final String LIST_STATE_ADD_ALL_VALUE_SIZE = "listStateAddAllValueSize";
        private static final String LIST_STATE_UPDATE_KEY_SIZE = "listStateUpdateKeySize";
        private static final String LIST_STATE_UPDATE_VALUE_SIZE = "listStateUpdateValueSize";
        private int getCount = 0;
        private int addCount = 0;
        private int addAllCount = 0;
        private int updateCount = 0;
        private int mergeNamespaceCount = 0;

        private ListStateMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getAddCount() {
            return this.addCount;
        }

        int getAddAllCount() {
            return this.addAllCount;
        }

        int getUpdateCount() {
            return this.updateCount;
        }

        int getMergeNamespaceCount() {
            return this.mergeNamespaceCount;
        }

        private boolean trackMetricsOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackMetricsOnAdd() {
            this.addCount = this.loopUpdateCounter(this.addCount);
            return this.addCount == 1;
        }

        private boolean trackMetricsOnAddAll() {
            this.addAllCount = this.loopUpdateCounter(this.addAllCount);
            return this.addAllCount == 1;
        }

        private boolean trackMetricsOnUpdate() {
            this.updateCount = this.loopUpdateCounter(this.updateCount);
            return this.updateCount == 1;
        }

        private boolean trackMetricsOnMergeNamespace() {
            this.mergeNamespaceCount = this.loopUpdateCounter(this.mergeNamespaceCount);
            return this.mergeNamespaceCount == 1;
        }
    }
}

