/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class HandlerRequest<R extends RequestBody> {
    private final R requestBody;
    private final Collection<File> uploadedFiles;
    private final Map<Class<? extends MessagePathParameter<?>>, MessagePathParameter<?>> pathParameters;
    private final Map<Class<? extends MessageQueryParameter<?>>, MessageQueryParameter<?>> queryParameters;

    private HandlerRequest(R requestBody, Map<Class<? extends MessagePathParameter<?>>, MessagePathParameter<?>> receivedPathParameters, Map<Class<? extends MessageQueryParameter<?>>, MessageQueryParameter<?>> receivedQueryParameters, Collection<File> uploadedFiles) {
        this.requestBody = (RequestBody)Preconditions.checkNotNull(requestBody);
        this.uploadedFiles = Collections.unmodifiableCollection(Preconditions.checkNotNull(uploadedFiles));
        this.pathParameters = Preconditions.checkNotNull(receivedPathParameters);
        this.queryParameters = Preconditions.checkNotNull(receivedQueryParameters);
    }

    public R getRequestBody() {
        return this.requestBody;
    }

    public <X, PP extends MessagePathParameter<X>> X getPathParameter(Class<PP> parameterClass) {
        MessagePathParameter<?> pathParameter = this.pathParameters.get(parameterClass);
        Preconditions.checkState(pathParameter != null, "No parameter could be found for the given class.");
        return pathParameter.getValue();
    }

    public <X, QP extends MessageQueryParameter<X>> List<X> getQueryParameter(Class<QP> parameterClass) {
        MessageQueryParameter<?> queryParameter = this.queryParameters.get(parameterClass);
        if (queryParameter == null) {
            return Collections.emptyList();
        }
        return (List)queryParameter.getValue();
    }

    @Nonnull
    public Collection<File> getUploadedFiles() {
        return this.uploadedFiles;
    }

    @VisibleForTesting
    public static <R extends RequestBody, M extends MessageParameters> HandlerRequest<R> create(R requestBody, M messageParameters) {
        return HandlerRequest.create(requestBody, messageParameters, Collections.emptyList());
    }

    @VisibleForTesting
    public static <R extends RequestBody, M extends MessageParameters> HandlerRequest<R> create(R requestBody, M messageParameters, Collection<File> uploadedFiles) {
        return new HandlerRequest<R>(requestBody, HandlerRequest.mapParameters(messageParameters.getPathParameters()), HandlerRequest.mapParameters(messageParameters.getQueryParameters()), uploadedFiles);
    }

    public static <R extends RequestBody, M extends MessageParameters> HandlerRequest<R> resolveParametersAndCreate(R requestBody, M messageParameters, Map<String, String> receivedPathParameters, Map<String, List<String>> receivedQueryParameters, Collection<File> uploadedFiles) throws HandlerRequestException {
        HandlerRequest.resolvePathParameters(messageParameters, receivedPathParameters);
        HandlerRequest.resolveQueryParameters(messageParameters, receivedQueryParameters);
        return HandlerRequest.create(requestBody, messageParameters, uploadedFiles);
    }

    private static void resolvePathParameters(MessageParameters messageParameters, Map<String, String> receivedPathParameters) throws HandlerRequestException {
        for (MessagePathParameter<?> pathParameter : messageParameters.getPathParameters()) {
            String value = receivedPathParameters.get(pathParameter.getKey());
            if (value == null) continue;
            try {
                pathParameter.resolveFromString(value);
            }
            catch (Exception e) {
                throw new HandlerRequestException("Cannot resolve path parameter (" + pathParameter.getKey() + ") from value \"" + value + "\".");
            }
        }
    }

    private static void resolveQueryParameters(MessageParameters messageParameters, Map<String, List<String>> receivedQueryParameters) throws HandlerRequestException {
        for (MessageQueryParameter<?> queryParameter : messageParameters.getQueryParameters()) {
            List<String> values = receivedQueryParameters.get(queryParameter.getKey());
            if (values == null || values.isEmpty()) continue;
            StringJoiner joiner = new StringJoiner(",");
            values.forEach(joiner::add);
            try {
                queryParameter.resolveFromString(joiner.toString());
            }
            catch (Exception e) {
                throw new HandlerRequestException("Cannot resolve query parameter (" + queryParameter.getKey() + ") from value \"" + String.valueOf(joiner) + "\".");
            }
        }
    }

    private static <P extends MessageParameter<?>> Map<Class<? extends P>, P> mapParameters(Collection<P> parameters) {
        HashMap<Class<?>, MessageParameter> mappedParameters = CollectionUtil.newHashMapWithExpectedSize(2);
        for (MessageParameter parameter : parameters) {
            if (!parameter.isResolved()) continue;
            Class<?> clazz = parameter.getClass();
            mappedParameters.put(clazz, parameter);
        }
        return mappedParameters;
    }
}

