/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.operators.sort.ExceptionHandler;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.sort.SorterInputGateway;
import org.apache.flink.runtime.operators.sort.StageRunner;
import org.apache.flink.runtime.operators.sort.ThreadBase;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

final class ReadingThread<E>
extends ThreadBase<E> {
    private final MutableObjectIterator<E> reader;
    private final E readTarget;
    private final SorterInputGateway<E> sorterGateway;

    ReadingThread(@Nullable ExceptionHandler<IOException> exceptionHandler, MutableObjectIterator<E> reader, StageRunner.StageMessageDispatcher<E> dispatcher, @Nullable LargeRecordHandler<E> largeRecordsHandler, @Nullable E readTarget, long startSpillingBytes) {
        super(exceptionHandler, "SortMerger Reading Thread", dispatcher);
        this.sorterGateway = new SorterInputGateway<E>(dispatcher, largeRecordsHandler, startSpillingBytes);
        this.reader = Preconditions.checkNotNull(reader);
        this.readTarget = readTarget;
    }

    @Override
    public void go() throws IOException, InterruptedException {
        MutableObjectIterator<E> reader = this.reader;
        E current = reader.next(this.readTarget);
        while (this.isRunning() && current != null) {
            this.sorterGateway.writeRecord(current);
            current = reader.next(current);
        }
        this.sorterGateway.finishReading();
    }
}

