/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

public abstract class ResultSubpartition {
    public static final int ADD_BUFFER_ERROR_CODE = -1;
    protected final ResultSubpartitionInfo subpartitionInfo;
    protected final ResultPartition parent;

    public ResultSubpartition(int index, ResultPartition parent) {
        this.parent = parent;
        this.subpartitionInfo = new ResultSubpartitionInfo(parent.getPartitionIndex(), index);
    }

    public ResultSubpartitionInfo getSubpartitionInfo() {
        return this.subpartitionInfo;
    }

    protected abstract long getTotalNumberOfBuffersUnsafe();

    protected abstract long getTotalNumberOfBytesUnsafe();

    public int getSubPartitionIndex() {
        return this.subpartitionInfo.getSubPartitionIdx();
    }

    protected void onConsumedSubpartition() {
        this.parent.onConsumedSubpartition(this.getSubPartitionIndex());
    }

    public abstract void alignedBarrierTimeout(long var1) throws IOException;

    public abstract void abortCheckpoint(long var1, CheckpointException var3);

    @VisibleForTesting
    public final int add(BufferConsumer bufferConsumer) throws IOException {
        return this.add(bufferConsumer, 0);
    }

    public abstract int add(BufferConsumer var1, int var2) throws IOException;

    public abstract void flush();

    public abstract int finish() throws IOException;

    public abstract void release() throws IOException;

    public abstract ResultSubpartitionView createReadView(BufferAvailabilityListener var1) throws IOException;

    public abstract boolean isReleased();

    abstract int getBuffersInBacklogUnsafe();

    public abstract int unsynchronizedGetNumberOfQueuedBuffers();

    public abstract int getNumberOfQueuedBuffers();

    public abstract void bufferSize(int var1);

    public static final class BufferAndBacklog {
        private final Buffer buffer;
        private final int buffersInBacklog;
        private final Buffer.DataType nextDataType;
        private final int sequenceNumber;

        public BufferAndBacklog(Buffer buffer, int buffersInBacklog, Buffer.DataType nextDataType, int sequenceNumber) {
            this.buffer = Preconditions.checkNotNull(buffer);
            this.buffersInBacklog = buffersInBacklog;
            this.nextDataType = Preconditions.checkNotNull(nextDataType);
            this.sequenceNumber = sequenceNumber;
        }

        public Buffer buffer() {
            return this.buffer;
        }

        public boolean isDataAvailable() {
            return this.nextDataType != Buffer.DataType.NONE;
        }

        public int buffersInBacklog() {
            return this.buffersInBacklog;
        }

        public boolean isEventAvailable() {
            return this.nextDataType.isEvent();
        }

        public Buffer.DataType getNextDataType() {
            return this.nextDataType;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public static BufferAndBacklog fromBufferAndLookahead(Buffer current, Buffer.DataType nextDataType, int backlog, int sequenceNumber) {
            return new BufferAndBacklog(current, backlog, nextDataType, sequenceNumber);
        }
    }
}

