/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state.v2;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.SerializerFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class StateSerializerReference<T>
extends AtomicReference<TypeSerializer<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(StateSerializerReference.class);
    @Nullable
    private final TypeInformation<T> typeInfo;

    public StateSerializerReference(TypeInformation<T> typeInfo) {
        super(null);
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "type information must not be null");
    }

    public StateSerializerReference(TypeSerializer<T> typeSerializer) {
        super(Preconditions.checkNotNull(typeSerializer, "type serializer must not be null"));
        this.typeInfo = null;
    }

    public StateSerializerReference(Class<T> clazz) {
        try {
            this.typeInfo = TypeExtractor.createTypeInfo(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the type information for '" + clazz.getName() + "'. The most common reason is failure to infer the generic type information, due to Java's type erasure. In that case, please pass a 'TypeHint' instead of a class to describe the type. For example, to describe 'Tuple2<String, String>' as a generic type, use 'new PravegaDeserializationSchema<>(new TypeHint<Tuple2<String, String>>(){}, serializer);'", e);
        }
    }

    public TypeInformation<T> getTypeInformation() {
        return this.typeInfo;
    }

    public boolean isInitialized() {
        return this.get() != null;
    }

    public void initializeUnlessSet(final ExecutionConfig executionConfig) {
        this.initializeUnlessSet(new SerializerFactory(){

            @Override
            public <T> TypeSerializer<T> createSerializer(TypeInformation<T> typeInformation) {
                return typeInformation.createSerializer(executionConfig == null ? null : executionConfig.getSerializerConfig());
            }
        });
    }

    @Internal
    public void initializeUnlessSet(SerializerFactory serializerFactory) {
        if (this.get() == null) {
            Preconditions.checkState(this.typeInfo != null, "type information should not be null.");
            TypeSerializer<T> serializer = serializerFactory.createSerializer(this.typeInfo);
            if (!this.compareAndSet(null, serializer)) {
                LOG.debug("Someone else beat us at initializing the serializer.");
            }
        }
    }
}

