/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.time.Duration;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;

@Internal
public class RestartStrategyDescriptionUtils {
    public static String getRestartStrategyDescription(Configuration configuration) {
        Optional<String> restartStrategyNameOptional = configuration.getOptional(RestartStrategyOptions.RESTART_STRATEGY);
        return restartStrategyNameOptional.map(restartStrategyName -> {
            switch (RestartStrategyOptions.RestartStrategyType.of(restartStrategyName.toLowerCase())) {
                case NO_RESTART_STRATEGY: {
                    return "Restart deactivated.";
                }
                case FIXED_DELAY: {
                    return RestartStrategyDescriptionUtils.getFixedDelayDescription(configuration);
                }
                case FAILURE_RATE: {
                    return RestartStrategyDescriptionUtils.getFailureRateDescription(configuration);
                }
                case EXPONENTIAL_DELAY: {
                    return RestartStrategyDescriptionUtils.getExponentialDelayDescription(configuration);
                }
            }
            throw new IllegalArgumentException("Unknown restart strategy " + restartStrategyName + ".");
        }).orElse("Cluster level default restart strategy");
    }

    private static String getExponentialDelayDescription(Configuration configuration) {
        Duration initialBackoff = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF);
        Duration maxBackoff = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF);
        double backoffMultiplier = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER);
        Duration resetBackoffThreshold = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD);
        double jitter = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR);
        return String.format("Restart with exponential delay: starting at %s, increasing by %f, with maximum %s. Delay resets after %s with jitter %f", initialBackoff, backoffMultiplier, maxBackoff, resetBackoffThreshold, jitter);
    }

    private static String getFailureRateDescription(Configuration configuration) {
        int maxFailures = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL);
        Duration failureRateInterval = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL);
        Duration failureRateDelay = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY);
        return String.format("Failure rate restart with maximum of %d failures within interval %s and fixed delay %s.", maxFailures, failureRateInterval, failureRateDelay);
    }

    private static String getFixedDelayDescription(Configuration configuration) {
        int attempts = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS);
        Duration delay = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY);
        return String.format("Restart with fixed delay (%s). #%d restart attempts.", delay, attempts);
    }
}

