/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
class DefaultStateTypeStrategy
implements StateTypeStrategy {
    private final TypeStrategy typeStrategy;
    @Nullable
    private final Duration timeToLive;

    DefaultStateTypeStrategy(TypeStrategy typeStrategy, @Nullable Duration timeToLive) {
        this.typeStrategy = Preconditions.checkNotNull(typeStrategy, "Type strategy must not be null.");
        this.timeToLive = timeToLive;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        return this.typeStrategy.inferType(callContext);
    }

    @Override
    public Optional<Duration> getTimeToLive(CallContext callContext) {
        return Optional.ofNullable(this.timeToLive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStateTypeStrategy that = (DefaultStateTypeStrategy)o;
        return Objects.equals(this.typeStrategy, that.typeStrategy) && Objects.equals(this.timeToLive, that.timeToLive);
    }

    public int hashCode() {
        return Objects.hash(this.typeStrategy, this.timeToLive);
    }
}

