/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.gateway.rest.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.gateway.rest.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class ColumnInfo {
    private static final String FIELD_NAME_NAME = "name";
    private static final String FIELD_NAME_TYPE = "logicalType";
    private static final String FIELD_NAME_COMMENT = "comment";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="logicalType")
    @JsonSerialize(using=LogicalTypeJsonSerializer.class)
    @JsonDeserialize(using=LogicalTypeJsonDeserializer.class)
    private final LogicalType logicalType;
    @JsonProperty(value="comment")
    @Nullable
    private final String comment;

    @JsonCreator
    public ColumnInfo(@JsonProperty(value="name") String name, @JsonProperty(value="logicalType") LogicalType logicalType, @JsonProperty(value="comment") String comment) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        this.logicalType = Preconditions.checkNotNull(logicalType, "logical type must not be null");
        this.comment = comment;
    }

    public static ColumnInfo toColumnInfo(Column column) {
        return new ColumnInfo(column.getName(), column.getDataType().getLogicalType(), column.getComment().orElse(null));
    }

    public Column toColumn() {
        return Column.physical(this.name, DataTypeUtils.toInternalDataType(this.logicalType)).withComment(this.comment);
    }

    public String getName() {
        return this.name;
    }

    public LogicalType getLogicalType() {
        return this.logicalType;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.logicalType, that.logicalType) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.logicalType, this.comment);
    }

    public String toString() {
        return "ColumnInfo{name='" + this.name + "', logicalType=" + this.logicalType + ", comment='" + this.comment + "'}";
    }
}

