/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliStrings;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.cli.Printer;
import org.apache.flink.table.client.cli.SqlCompleter;
import org.apache.flink.table.client.cli.TerminalUtils;
import org.apache.flink.table.client.cli.parser.SqlClientSyntaxHighlighter;
import org.apache.flink.table.client.cli.parser.SqlCommandParserImpl;
import org.apache.flink.table.client.cli.parser.SqlMultiLineParser;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.util.FileUtils;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CliClient.class);
    public static final Supplier<Terminal> DEFAULT_TERMINAL_FACTORY = TerminalUtils::createDefaultTerminal;
    private static final String NEWLINE_PROMPT = new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(2)).append("Flink SQL").style(AttributedStyle.DEFAULT).append("> ").toAnsi();
    private static final String SHOW_LINE_NUMBERS_PATTERN = "%N%M> ";
    private final Executor executor;
    private final java.nio.file.Path historyFilePath;
    @Nullable
    private final MaskingCallback inputTransformer;
    private final Supplier<Terminal> terminalFactory;
    private Terminal terminal;
    private boolean isRunning;

    @VisibleForTesting
    public CliClient(Supplier<Terminal> terminalFactory, Executor executor, java.nio.file.Path historyFilePath, @Nullable MaskingCallback inputTransformer) {
        this.terminalFactory = terminalFactory;
        this.executor = executor;
        this.inputTransformer = inputTransformer;
        this.historyFilePath = historyFilePath;
    }

    public CliClient(Supplier<Terminal> terminalFactory, Executor executor, java.nio.file.Path historyFilePath) {
        this(terminalFactory, executor, historyFilePath, null);
    }

    @Override
    public void close() {
        if (this.terminal != null) {
            this.closeTerminal();
        }
    }

    public void executeInInteractiveMode() {
        this.executeInInteractiveMode(null);
    }

    @VisibleForTesting
    void executeInInteractiveMode(LineReader lineReader) {
        try {
            this.terminal = this.terminalFactory.get();
            this.executeInteractive(lineReader);
        }
        finally {
            this.closeTerminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInNonInteractiveMode(URI uri) {
        try {
            this.terminal = this.terminalFactory.get();
            if (CliUtils.isApplicationMode(this.executor.getSessionConfig())) {
                String scheme = StringUtils.lowerCase((String)uri.getScheme());
                String clusterId = scheme == null || scheme.equals("file") ? this.executor.deployScript(CliClient.readFile(uri), null) : this.executor.deployScript(null, uri);
                this.terminal.writer().println(CliStrings.messageInfo("Deploy script in application mode: ").toAnsi());
                this.terminal.writer().println(String.format("Cluster ID: %s\n", clusterId));
                this.terminal.flush();
            } else {
                this.executeFile(CliClient.readFile(uri), this.terminal.output(), ExecutionMode.NON_INTERACTIVE_EXECUTION);
            }
        }
        finally {
            this.closeTerminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeInitialization(URI file) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
            this.terminal = TerminalUtils.createDumbTerminal(outputStream);
            boolean success = this.executeFile(CliClient.readFile(file), outputStream, ExecutionMode.INITIALIZATION);
            LOG.info(((Object)outputStream).toString());
            boolean bl = success;
            return bl;
        }
        finally {
            this.closeTerminal();
        }
    }

    private void executeInteractive(LineReader inputLineReader) {
        this.terminal.writer().println();
        this.terminal.writer().flush();
        this.terminal.writer().append(CliStrings.MESSAGE_WELCOME);
        LineReader lineReader = inputLineReader == null ? this.createLineReader(this.terminal, ExecutionMode.INTERACTIVE_EXECUTION) : inputLineReader;
        this.getAndExecuteStatements(lineReader, false);
    }

    private boolean getAndExecuteStatements(LineReader lineReader, boolean exitOnFailure) {
        this.isRunning = true;
        SqlMultiLineParser parser = (SqlMultiLineParser)lineReader.getParser();
        while (this.isRunning) {
            this.terminal.writer().append("\n");
            this.terminal.flush();
            try {
                String line = lineReader.readLine(NEWLINE_PROMPT, null, this.inputTransformer, null);
                lineReader.setVariable("secondary-prompt-pattern", this.executor.getSessionConfig().get(SqlClientOptions.DISPLAY_SHOW_LINE_NUMBERS) != false ? SHOW_LINE_NUMBERS_PATTERN : "%M> ");
                if (line.trim().isEmpty()) continue;
                Printer printer = parser.getPrinter();
                boolean success = this.print(printer);
                if (!exitOnFailure || success) continue;
                return false;
            }
            catch (UserInterruptException printer) {
            }
            catch (IOError | EndOfFileException e) {
                break;
            }
            catch (SqlExecutionException e) {
                this.printExecutionException(e);
                if (!exitOnFailure) continue;
                return false;
            }
            catch (Throwable t) {
                throw new SqlClientException("Could not read from command line.", t);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean executeFile(String content, OutputStream outputStream, ExecutionMode mode) {
        this.terminal.writer().println(CliStrings.messageInfo("Executing SQL from file.").toAnsi());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(SqlMultiLineParser.formatSqlFile(content).getBytes());){
            boolean bl;
            block13: {
                Terminal dumbTerminal = TerminalUtils.createDumbTerminal(inputStream, outputStream);
                try {
                    LineReader lineReader = this.createLineReader(dumbTerminal, mode);
                    bl = this.getAndExecuteStatements(lineReader, true);
                    if (dumbTerminal == null) break block13;
                }
                catch (Throwable throwable) {
                    if (dumbTerminal != null) {
                        try {
                            dumbTerminal.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dumbTerminal.close();
            }
            return bl;
        }
        catch (Throwable e) {
            this.printExecutionException(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean print(Printer printer) {
        try {
            Thread thread = Thread.currentThread();
            Terminal.SignalHandler previousHandler = this.terminal.handle(Terminal.Signal.INT, signal -> thread.interrupt());
            try {
                printer.print(this.terminal);
                if (printer.isQuitCommand()) {
                    this.isRunning = false;
                }
            }
            finally {
                this.terminal.handle(Terminal.Signal.INT, previousHandler);
            }
        }
        catch (SqlExecutionException e) {
            this.printExecutionException(e);
            return false;
        }
        return true;
    }

    private void printExecutionException(Throwable t) {
        String errorMessage = "Could not execute SQL statement.";
        LOG.warn("Could not execute SQL statement.", t);
        boolean isVerbose = this.executor.getSessionConfig().get(SqlClientOptions.VERBOSE);
        this.terminal.writer().println(CliStrings.messageError("Could not execute SQL statement.", t, isVerbose).toAnsi());
        this.terminal.flush();
    }

    private void closeTerminal() {
        try {
            this.terminal.close();
            this.terminal = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private LineReader createLineReader(Terminal terminal, ExecutionMode mode) {
        SqlMultiLineParser parser = new SqlMultiLineParser(new SqlCommandParserImpl(), this.executor, mode);
        LineReaderBuilder builder = LineReaderBuilder.builder().terminal(terminal).appName("Flink SQL CLI Client").parser(parser);
        if (mode == ExecutionMode.INTERACTIVE_EXECUTION) {
            builder.completer(new SqlCompleter(this.executor));
            builder.highlighter(new SqlClientSyntaxHighlighter(this.executor));
        }
        LineReader lineReader = builder.build();
        lineReader.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        lineReader.setVariable("errors", 1);
        lineReader.option(LineReader.Option.CASE_INSENSITIVE, true);
        if (Files.exists(this.historyFilePath, new LinkOption[0]) || CliUtils.createFile(this.historyFilePath)) {
            String msg = "Command history file path: " + this.historyFilePath;
            terminal.writer().println(msg);
            LOG.info(msg);
            lineReader.setVariable("history-file", this.historyFilePath);
        } else {
            String msg = "Unable to create history file: " + this.historyFilePath;
            terminal.writer().println(msg);
            LOG.warn(msg);
        }
        return lineReader;
    }

    public static String readFile(URI uri) {
        try {
            if (uri.getScheme() != null && (uri.getScheme().equals("http") || uri.getScheme().equals("https"))) {
                return CliClient.readFromHttp(uri);
            }
            return CliClient.readFileUtf8(uri);
        }
        catch (IOException e) {
            throw new SqlClientException("Failed to read file " + uri, e);
        }
    }

    private static String readFromHttp(URI uri) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
        conn.setRequestMethod("GET");
        try (InputStream inputStream = conn.getInputStream();){
            String string;
            try (ByteArrayOutputStream targetFile = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)targetFile);
                string = targetFile.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    private static String readFileUtf8(URI uri) throws IOException {
        Path path = new Path(uri.toString());
        FileSystem fs = path.getFileSystem();
        try (FSDataInputStream inputStream = fs.open(path);){
            String string = new String(FileUtils.read(inputStream, (int)fs.getFileStatus(path).getLen()), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static enum ExecutionMode {
        INTERACTIVE_EXECUTION,
        NON_INTERACTIVE_EXECUTION,
        INITIALIZATION;

    }
}

