/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.asyncprocessing;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncKeyOrderedProcessingOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.function.ThrowingConsumer;

@Internal
public interface AsyncKeyOrderedProcessing {
    public boolean isAsyncKeyOrderedProcessingEnabled();

    public <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor(int var1);

    public static <T> ThrowingConsumer<StreamRecord<T>, Exception> makeRecordProcessor(AsyncKeyOrderedProcessingOperator asyncOperator, KeySelector<T, ?> keySelector, ThrowingConsumer<StreamRecord<T>, Exception> processor) {
        if (keySelector == null) {
            return processor;
        }
        switch (asyncOperator.getElementOrder()) {
            case RECORD_ORDER: {
                return record -> {
                    asyncOperator.setAsyncKeyedContextElement(record, keySelector);
                    asyncOperator.preserveRecordOrderAndProcess(() -> processor.accept((StreamRecord)record));
                    asyncOperator.postProcessElement();
                };
            }
            case FIRST_REQUEST_ORDER: {
                return record -> {
                    asyncOperator.setAsyncKeyedContextElement(record, keySelector);
                    processor.accept((StreamRecord)record);
                    asyncOperator.postProcessElement();
                };
            }
        }
        throw new UnsupportedOperationException("Unknown element order for async processing:" + asyncOperator.getElementOrder());
    }
}

