/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.streaming.api.operators.source.TimestampsAndWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;

@Internal
public final class WatermarkToDataOutput
implements WatermarkOutput {
    private final PushingAsyncDataInput.DataOutput<?> output;
    private final TimestampsAndWatermarks.WatermarkUpdateListener watermarkEmitted;
    private long maxWatermarkSoFar;
    private boolean isIdle;

    @VisibleForTesting
    public WatermarkToDataOutput(PushingAsyncDataInput.DataOutput<?> output) {
        this(output, new TimestampsAndWatermarks.WatermarkUpdateListener(){

            @Override
            public void updateIdle(boolean isIdle) {
            }

            @Override
            public void updateCurrentEffectiveWatermark(long watermark) {
            }

            @Override
            public void updateCurrentSplitWatermark(String splitId, long watermark) {
            }

            @Override
            public void updateCurrentSplitIdle(String splitId, boolean isIdle) {
            }

            @Override
            public void splitFinished(String splitId) {
            }
        });
    }

    public WatermarkToDataOutput(PushingAsyncDataInput.DataOutput<?> output, TimestampsAndWatermarks.WatermarkUpdateListener watermarkEmitted) {
        this.output = Preconditions.checkNotNull(output);
        this.watermarkEmitted = Preconditions.checkNotNull(watermarkEmitted);
        this.maxWatermarkSoFar = Long.MIN_VALUE;
    }

    @Override
    public void emitWatermark(org.apache.flink.api.common.eventtime.Watermark watermark) {
        long newWatermark = watermark.getTimestamp();
        if (newWatermark <= this.maxWatermarkSoFar) {
            return;
        }
        this.maxWatermarkSoFar = newWatermark;
        this.watermarkEmitted.updateCurrentEffectiveWatermark(this.maxWatermarkSoFar);
        try {
            this.markActiveInternally();
            this.output.emitWatermark(new Watermark(newWatermark));
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void markIdle() {
        if (this.isIdle) {
            return;
        }
        try {
            this.output.emitWatermarkStatus(WatermarkStatus.IDLE);
            this.watermarkEmitted.updateIdle(true);
            this.isIdle = true;
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void markActive() {
        try {
            this.markActiveInternally();
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    private boolean markActiveInternally() throws Exception {
        if (!this.isIdle) {
            return true;
        }
        this.output.emitWatermarkStatus(WatermarkStatus.ACTIVE);
        this.watermarkEmitted.updateIdle(false);
        this.isIdle = false;
        return false;
    }
}

