/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.time.Duration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.Preconditions;

public final class BufferDebloatConfiguration {
    private final Duration targetTotalTime;
    private final int startingBufferSize;
    private final int maxBufferSize;
    private final int minBufferSize;
    private final int bufferDebloatThresholdPercentages;
    private final int numberOfSamples;
    private final boolean enabled;

    private BufferDebloatConfiguration(boolean enabled, Duration targetTotalTime, int startingBufferSize, int maxBufferSize, int minBufferSize, int bufferDebloatThresholdPercentages, int numberOfSamples) {
        Preconditions.checkArgument(maxBufferSize > 0);
        Preconditions.checkArgument(minBufferSize > 0);
        Preconditions.checkArgument(numberOfSamples > 0);
        Preconditions.checkArgument(maxBufferSize >= minBufferSize);
        Preconditions.checkArgument((double)targetTotalTime.toMillis() > 0.0);
        Preconditions.checkArgument(maxBufferSize >= startingBufferSize);
        Preconditions.checkArgument(minBufferSize <= startingBufferSize);
        this.targetTotalTime = Preconditions.checkNotNull(targetTotalTime);
        this.startingBufferSize = startingBufferSize;
        this.maxBufferSize = maxBufferSize;
        this.minBufferSize = minBufferSize;
        this.bufferDebloatThresholdPercentages = bufferDebloatThresholdPercentages;
        this.numberOfSamples = numberOfSamples;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Duration getTargetTotalTime() {
        return this.targetTotalTime;
    }

    public int getStartingBufferSize() {
        return this.startingBufferSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMinBufferSize() {
        return this.minBufferSize;
    }

    public int getBufferDebloatThresholdPercentages() {
        return this.bufferDebloatThresholdPercentages;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public static BufferDebloatConfiguration fromConfiguration(ReadableConfig config) {
        Duration targetTotalTime = config.get(TaskManagerOptions.BUFFER_DEBLOAT_TARGET);
        int maxBufferSize = Math.toIntExact(config.get(TaskManagerOptions.MEMORY_SEGMENT_SIZE).getBytes());
        int minBufferSize = Math.toIntExact(config.get(TaskManagerOptions.MIN_MEMORY_SEGMENT_SIZE).getBytes());
        int startingBufferSize = Math.toIntExact(config.get(TaskManagerOptions.STARTING_MEMORY_SEGMENT_SIZE).getBytes());
        int bufferDebloatThresholdPercentages = config.get(TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES);
        int numberOfSamples = config.get(TaskManagerOptions.BUFFER_DEBLOAT_SAMPLES);
        return new BufferDebloatConfiguration(config.get(TaskManagerOptions.BUFFER_DEBLOAT_ENABLED), targetTotalTime, startingBufferSize, maxBufferSize, minBufferSize, bufferDebloatThresholdPercentages, numberOfSamples);
    }
}

