/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.MapSerializerSnapshot;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshot;

public class TtlAwareSerializerSnapshotWrapper<T> {
    private final TypeSerializerSnapshot<T> typeSerializerSnapshot;

    public TtlAwareSerializerSnapshotWrapper(TypeSerializerSnapshot<T> typeSerializerSnapshot) {
        this.typeSerializerSnapshot = typeSerializerSnapshot;
    }

    public TypeSerializerSnapshot<T> getTtlAwareSerializerSnapshot() {
        if (this.typeSerializerSnapshot instanceof ListSerializerSnapshot) {
            return this.wrapListSerializerSnapshot();
        }
        if (this.typeSerializerSnapshot instanceof MapSerializerSnapshot) {
            return this.wrapMapSerializerSnapshot();
        }
        return this.wrapValueSerializerSnapshot();
    }

    private TypeSerializerSnapshot<T> wrapValueSerializerSnapshot() {
        return this.typeSerializerSnapshot instanceof TtlAwareSerializerSnapshot ? this.typeSerializerSnapshot : new TtlAwareSerializerSnapshot<T>(this.typeSerializerSnapshot);
    }

    private TypeSerializerSnapshot<T> wrapListSerializerSnapshot() {
        ListSerializerSnapshot listSerializerSnapshot = (ListSerializerSnapshot)this.typeSerializerSnapshot;
        if (!(listSerializerSnapshot.getElementSerializerSnapshot() instanceof TtlAwareSerializerSnapshot)) {
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots(listSerializerSnapshot, new TtlAwareSerializerSnapshot(listSerializerSnapshot.getElementSerializerSnapshot()));
        }
        return listSerializerSnapshot;
    }

    private TypeSerializerSnapshot<T> wrapMapSerializerSnapshot() {
        MapSerializerSnapshot mapSerializerSnapshot = (MapSerializerSnapshot)this.typeSerializerSnapshot;
        if (!(mapSerializerSnapshot.getValueSerializerSnapshot() instanceof TtlAwareSerializerSnapshot)) {
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots(mapSerializerSnapshot, mapSerializerSnapshot.getKeySerializerSnapshot(), new TtlAwareSerializerSnapshot(mapSerializerSnapshot.getValueSerializerSnapshot()));
        }
        return mapSerializerSnapshot;
    }
}

