/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class MetricsTrackingStateConfig {
    private final MetricGroup metricGroup;
    private final boolean enabled;
    private final int sampleInterval;
    private final int historySize;
    private final boolean stateNameAsVariable;

    MetricsTrackingStateConfig(MetricGroup metricGroup, boolean enabled, int sampleInterval, int historySize, boolean stateNameAsVariable) {
        if (enabled) {
            Preconditions.checkNotNull(metricGroup, "Metric group cannot be null if metrics tracking is enabled.");
            Preconditions.checkArgument(sampleInterval >= 1);
        }
        this.metricGroup = metricGroup;
        this.enabled = enabled;
        this.sampleInterval = sampleInterval;
        this.historySize = historySize;
        this.stateNameAsVariable = stateNameAsVariable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public boolean isStateNameAsVariable() {
        return this.stateNameAsVariable;
    }

    public static abstract class Builder<T extends MetricsTrackingStateConfig, B extends Builder<T, B>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected boolean enabled;
        protected int sampleInterval;
        protected int historySize;
        protected boolean stateNameAsVariable;
        protected MetricGroup metricGroup;

        public B setEnabled(boolean enabled) {
            this.enabled = enabled;
            return (B)this;
        }

        public B setSampleInterval(int sampleInterval) {
            this.sampleInterval = sampleInterval;
            return (B)this;
        }

        public B setHistorySize(int historySize) {
            this.historySize = historySize;
            return (B)this;
        }

        public B setStateNameAsVariable(boolean stateNameAsVariable) {
            this.stateNameAsVariable = stateNameAsVariable;
            return (B)this;
        }

        public B setMetricGroup(MetricGroup metricGroup) {
            this.metricGroup = metricGroup;
            return (B)this;
        }

        public abstract T build();
    }
}

