/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.cluster.AbstractJobManagerFileHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.ProfilingFileNamePathParameter;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.messages.cluster.ProfilingFileMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobManagerProfilingFileHandler
extends AbstractJobManagerFileHandler<ProfilingFileMessageParameters> {
    private final String profilingResultDir;

    public JobManagerProfilingFileHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, UntypedResponseMessageHeaders<EmptyRequestBody, ProfilingFileMessageParameters> messageHeaders, Configuration configs) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.profilingResultDir = configs.get(RestOptions.PROFILING_RESULT_DIR);
    }

    @Override
    protected File getFile(HandlerRequest<EmptyRequestBody> handlerRequest) {
        if (this.profilingResultDir == null) {
            return null;
        }
        String filename = new File((String)handlerRequest.getPathParameter(ProfilingFileNamePathParameter.class)).getName();
        return new File(this.profilingResultDir, filename);
    }
}

