/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.util.SerializedValue;

public class JobGraphBuilder {
    private final JobType jobType;
    private final List<JobVertex> jobVertices = new ArrayList<JobVertex>();
    private final Map<String, DistributedCache.DistributedCacheEntry> userArtifacts = new HashMap<String, DistributedCache.DistributedCacheEntry>();
    private final List<URL> classpaths = new ArrayList<URL>();
    private String jobName = "Unnamed job";
    @Nullable
    private JobID jobId = null;
    @Nullable
    private SerializedValue<ExecutionConfig> serializedExecutionConfig = null;
    @Nullable
    private JobCheckpointingSettings jobCheckpointingSettings = null;
    @Nullable
    private SavepointRestoreSettings savepointRestoreSettings = null;
    @Nullable
    private Configuration jobConfiguration = null;

    private JobGraphBuilder(JobType jobType) {
        this.jobType = jobType;
    }

    public JobGraphBuilder setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public JobGraphBuilder addJobVertices(Collection<? extends JobVertex> jobVerticesToAdd) {
        this.jobVertices.addAll(jobVerticesToAdd);
        return this;
    }

    public JobGraphBuilder addJobVertex(JobVertex jobVertex) {
        return this.addJobVertices(Collections.singleton(jobVertex));
    }

    public JobGraphBuilder setJobId(JobID jobId) {
        this.jobId = jobId;
        return this;
    }

    public JobGraphBuilder setExecutionConfig(ExecutionConfig newExecutionConfig) throws IOException {
        this.serializedExecutionConfig = new SerializedValue<ExecutionConfig>(newExecutionConfig);
        return this;
    }

    public JobGraphBuilder addUserArtifacts(Map<String, DistributedCache.DistributedCacheEntry> newUserArtifacts) {
        this.userArtifacts.putAll(newUserArtifacts);
        return this;
    }

    public JobGraphBuilder setJobCheckpointingSettings(JobCheckpointingSettings newJobCheckpointingSettings) {
        this.jobCheckpointingSettings = newJobCheckpointingSettings;
        return this;
    }

    public JobGraphBuilder setSavepointRestoreSettings(SavepointRestoreSettings newSavepointRestoreSettings) {
        this.savepointRestoreSettings = newSavepointRestoreSettings;
        return this;
    }

    public JobGraphBuilder addClasspaths(Collection<URL> additionalClasspaths) {
        this.classpaths.addAll(additionalClasspaths);
        return this;
    }

    public JobGraphBuilder setJobConfiguration(Configuration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        return this;
    }

    public JobGraph build() {
        JobGraph jobGraph = new JobGraph(this.jobId, this.jobName, this.jobVertices.toArray(new JobVertex[0]));
        jobGraph.setJobType(this.jobType);
        if (this.serializedExecutionConfig != null) {
            jobGraph.setSerializedExecutionConfig(this.serializedExecutionConfig);
        }
        for (Map.Entry<String, DistributedCache.DistributedCacheEntry> entry : this.userArtifacts.entrySet()) {
            jobGraph.addUserArtifact(entry.getKey(), entry.getValue());
        }
        if (this.jobCheckpointingSettings != null) {
            jobGraph.setSnapshotSettings(this.jobCheckpointingSettings);
        }
        if (this.savepointRestoreSettings != null) {
            jobGraph.setSavepointRestoreSettings(this.savepointRestoreSettings);
        }
        if (!this.classpaths.isEmpty()) {
            jobGraph.setClasspaths(this.classpaths);
        }
        if (this.jobConfiguration != null) {
            jobGraph.setJobConfiguration(this.jobConfiguration);
        }
        return jobGraph;
    }

    public static JobGraphBuilder newStreamingJobGraphBuilder() {
        return new JobGraphBuilder(JobType.STREAMING);
    }

    public static JobGraphBuilder newBatchJobGraphBuilder() {
        return new JobGraphBuilder(JobType.BATCH);
    }
}

