/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.declare;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.declare.ContextVariable;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationException;
import org.apache.flink.runtime.asyncprocessing.declare.DeclaredVariable;
import org.apache.flink.runtime.asyncprocessing.declare.NamedCallback;

public class DeclarationManager {
    private final Map<String, NamedCallback> knownCallbacks = new HashMap<String, NamedCallback>();
    private final Map<String, DeclaredVariable<?>> knownVariables = new HashMap();
    private RecordContext<?> currentContext;
    private int nextValidNameSequence = 0;
    private int contextVariableCount = 0;

    <T extends NamedCallback> T register(T knownCallback) throws DeclarationException {
        if (this.knownCallbacks.put(knownCallback.getName(), knownCallback) != null) {
            throw new DeclarationException("Duplicated function key " + knownCallback.getName());
        }
        return knownCallback;
    }

    <T> ContextVariable<T> registerVariable(@Nullable Supplier<T> initializer) throws DeclarationException {
        return new ContextVariable<T>(this, this.contextVariableCount++, initializer);
    }

    <T> DeclaredVariable<T> registerVariable(TypeSerializer<T> serializer, String name, @Nullable Supplier<T> initializer) throws DeclarationException {
        if (this.knownVariables.containsKey(name)) {
            throw new DeclarationException("Duplicated variable key " + name);
        }
        DeclaredVariable<T> variable = new DeclaredVariable<T>(this, this.contextVariableCount++, serializer, name, initializer);
        this.knownVariables.put(name, variable);
        return variable;
    }

    public void setCurrentContext(RecordContext<?> currentContext) {
        this.currentContext = currentContext;
    }

    public <T> T getVariableValue(int ordinal) {
        if (this.currentContext == null) {
            throw new UnsupportedOperationException("There is no current keyed context.");
        }
        return this.currentContext.getVariable(ordinal);
    }

    public <T> void setVariableValue(int ordinal, T value) {
        if (this.currentContext == null) {
            throw new UnsupportedOperationException("There is no current keyed context.");
        }
        this.currentContext.setVariable(ordinal, value);
    }

    public int variableCount() {
        return this.contextVariableCount;
    }

    String nextAssignedName(String prefix) {
        String name;
        while (this.knownCallbacks.containsKey(name = String.format("___%s%d___", prefix, this.nextValidNameSequence++)) || this.knownVariables.containsKey(name)) {
        }
        return name;
    }
}

