/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.LineBreakElement;
import org.apache.flink.configuration.description.TextElement;

@Experimental
public class TraceOptions {
    private static final String NAMED_REPORTER_CONFIG_PREFIX = "traces.reporter.<name>";
    public static final ConfigOption<String> TRACE_REPORTERS_LIST = ConfigOptions.key("traces.reporters").stringType().noDefaultValue().withDescription("An optional list of trace reporter names. If configured, only reporters whose name matches any of the names in the list will be started. Otherwise, all reporters that could be found in the configuration will be started.");
    @Deprecated
    public static final ConfigOption<Boolean> REPORT_EVENTS_AS_SPANS = ConfigOptions.key("traces.report-events-as-spans").booleanType().defaultValue(false).withDescription("Whether to report events as spans. This is a temporary parameter that is in place until we have support for reporting events. In the meantime, this can be activated to report them as spans instead.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=1)
    public static final ConfigOption<String> REPORTER_FACTORY_CLASS = ConfigOptions.key("factory.class").stringType().noDefaultValue().withDescription("The reporter factory class to use for the reporter named <name>.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=5)
    public static final ConfigOption<String> REPORTER_CONFIG_PARAMETER = ConfigOptions.key("<parameter>").stringType().noDefaultValue().withDescription("Configures the parameter <parameter> for the reporter named <name>.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=4)
    public static final ConfigOption<Map<String, String>> REPORTER_ADDITIONAL_VARIABLES = ConfigOptions.key("scope.variables.additional").mapType().defaultValue(Collections.emptyMap()).withDescription("The map of additional variables that should be included for the reporter named <name>.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=2)
    public static final ConfigOption<String> REPORTER_SCOPE_DELIMITER = ConfigOptions.key("scope.delimiter").stringType().defaultValue(".").withDescription("The delimiter used to assemble the metric identifier for the reporter named <name>.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=3)
    public static final ConfigOption<String> REPORTER_EXCLUDED_VARIABLES = ConfigOptions.key("scope.variables.excludes").stringType().defaultValue(".").withDescription("The set of variables that should be excluded for the reporter named <name>. Only applicable to tag-based reporters.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=6)
    public static final ConfigOption<List<String>> REPORTER_INCLUDES = ConfigOptions.key("filter.includes").stringType().asList().defaultValues((String[])new String[]{"*:*:*"}).withDescription(Description.builder().text("The spans that should be included for the reporter named <name>. Filters are specified as a list, with each filter following this format:").linebreak().text("%s", TextElement.code("<scope>[:<name>[,<name>]]")).linebreak().text("A span matches a filter if the scope pattern and at least one of the name patterns match.").linebreak().list(TextElement.text("scope: Filters based on the logical scope.%sSpecified as a pattern where %s matches any sequence of characters and %s separates scope components.%s%sFor example:%s \"%s\" matches any job-related spans on the JobManager,%s \"%s\" matches all job-related spans and%s \"%s\" matches all spans below the job-level (i.e., task/operator spans etc.).%s%s", LineBreakElement.linebreak(), TextElement.code("*"), TextElement.code("."), LineBreakElement.linebreak(), LineBreakElement.linebreak(), LineBreakElement.linebreak(), TextElement.code("jobmanager.job"), LineBreakElement.linebreak(), TextElement.code("*.job"), LineBreakElement.linebreak(), TextElement.code("*.job.*"), LineBreakElement.linebreak(), LineBreakElement.linebreak()), TextElement.text("name: Filters based on the span name.%sSpecified as a comma-separate list of patterns where %s matches any sequence of characters.%s%sFor example, \"%s\" matches any span where the name contains %s.", LineBreakElement.linebreak(), TextElement.code("*"), LineBreakElement.linebreak(), LineBreakElement.linebreak(), TextElement.code("*Records*,*Bytes*"), TextElement.code("\"Records\" or \"Bytes\""))).build());
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=7)
    public static final ConfigOption<List<String>> REPORTER_EXCLUDES = ConfigOptions.key("filter.excludes").stringType().asList().defaultValues((String[])new String[0]).withDescription(Description.builder().text("The spans that should be excluded for the reporter named <name>. The format is identical to %s", TextElement.code(REPORTER_INCLUDES.key())).linebreak().build());

    @Experimental
    public static Configuration forReporter(Configuration configuration, String reporterName) {
        return new DelegatingConfiguration(configuration, "traces.reporter." + reporterName + ".");
    }

    @Experimental
    public static Configuration forTraceReporter(Configuration configuration, String reporterName) {
        return new DelegatingConfiguration(configuration, "traces.reporter." + reporterName + ".");
    }

    private TraceOptions() {
    }
}

