/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.AbstractCustomCommandLine;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.DynamicPropertiesUtil;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.NetUtils;

public class DefaultCLI
extends AbstractCustomCommandLine {
    public static final String ID = "default";
    private static final Option addressOption = new Option("m", "jobmanager", true, "Address of the JobManager to which to connect. Use this flag to connect to a different JobManager than the one specified in the configuration. Attention: This option is respected only if the high-availability configuration is NONE.");

    @Override
    public boolean isActive(CommandLine commandLine) {
        return true;
    }

    @Override
    public Configuration toConfiguration(CommandLine commandLine) throws FlinkException {
        Configuration resultingConfiguration = super.toConfiguration(commandLine);
        if (commandLine.hasOption(addressOption.getOpt())) {
            String addressWithPort = commandLine.getOptionValue(addressOption.getOpt());
            InetSocketAddress jobManagerAddress = NetUtils.parseHostPortAddress(addressWithPort);
            CliFrontend.setJobManagerAddressInConfig(resultingConfiguration, jobManagerAddress);
            URL url = NetUtils.getCorrectHostnamePort(addressWithPort);
            resultingConfiguration.set((ConfigOption)RestOptions.PATH, url.getPath());
            resultingConfiguration.set((ConfigOption)SecurityOptions.SSL_REST_ENABLED, (Object)DefaultCLI.isHttpsProtocol(url));
        }
        resultingConfiguration.set((ConfigOption)DeploymentOptions.TARGET, "remote");
        DynamicPropertiesUtil.encodeDynamicProperties(commandLine, resultingConfiguration);
        return resultingConfiguration;
    }

    private static boolean isHttpsProtocol(URL url) {
        return url.getProtocol() != null && url.getProtocol().equalsIgnoreCase("https");
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        super.addGeneralOptions(baseOptions);
        baseOptions.addOption(addressOption);
        baseOptions.addOption(DynamicPropertiesUtil.DYNAMIC_PROPERTIES);
    }
}

