/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.operators.MailOptionsImpl;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.FutureTaskWithException;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingRunnable;

@PublicEvolving
public interface MailboxExecutor {
    public static final Object[] EMPTY_ARGS = new Object[0];

    default public void execute(ThrowingRunnable<? extends Exception> command, String description) {
        this.execute(command, description, EMPTY_ARGS);
    }

    default public void execute(MailOptions mailOptions, ThrowingRunnable<? extends Exception> command, String description) {
        this.execute(mailOptions, command, description, EMPTY_ARGS);
    }

    default public void execute(ThrowingRunnable<? extends Exception> command, String descriptionFormat, Object ... descriptionArgs) {
        this.execute(MailOptions.options(), command, descriptionFormat, descriptionArgs);
    }

    public void execute(MailOptions var1, ThrowingRunnable<? extends Exception> var2, String var3, Object ... var4);

    @Nonnull
    default public Future<Void> submit(@Nonnull RunnableWithException command, String descriptionFormat, Object ... descriptionArgs) {
        FutureTaskWithException<Void> future = new FutureTaskWithException<Void>(command);
        this.execute(future, descriptionFormat, descriptionArgs);
        return future;
    }

    @Nonnull
    default public Future<Void> submit(@Nonnull RunnableWithException command, String description) {
        FutureTaskWithException<Void> future = new FutureTaskWithException<Void>(command);
        this.execute(future, description, EMPTY_ARGS);
        return future;
    }

    @Nonnull
    default public <T> Future<T> submit(@Nonnull Callable<T> command, String descriptionFormat, Object ... descriptionArgs) {
        FutureTaskWithException<T> future = new FutureTaskWithException<T>(command);
        this.execute(future, descriptionFormat, descriptionArgs);
        return future;
    }

    @Nonnull
    default public <T> Future<T> submit(@Nonnull Callable<T> command, String description) {
        FutureTaskWithException<T> future = new FutureTaskWithException<T>(command);
        this.execute(future, description, EMPTY_ARGS);
        return future;
    }

    public void yield() throws InterruptedException, FlinkRuntimeException;

    public boolean tryYield() throws FlinkRuntimeException;

    public boolean shouldInterrupt();

    @PublicEvolving
    public static interface MailOptions {
        public boolean isDeferrable();

        public boolean isUrgent();

        public static MailOptions options() {
            return MailOptionsImpl.DEFAULT;
        }

        public static MailOptions deferrable() {
            return MailOptionsImpl.DEFERRABLE;
        }

        public static MailOptions urgent() {
            return MailOptionsImpl.URGENT;
        }
    }
}

