/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.SinkWriter;

@Internal
public class PrintSinkOutputWriter<IN>
implements Serializable,
SinkWriter<IN> {
    private static final long serialVersionUID = 1L;
    private final boolean isStdErr;
    private transient PrintStream stream;
    private final String sinkIdentifier;
    private transient String completedPrefix;

    public PrintSinkOutputWriter() {
        this("", false);
    }

    public PrintSinkOutputWriter(boolean isStdErr) {
        this("", isStdErr);
    }

    public PrintSinkOutputWriter(String sinkIdentifier, boolean isStdErr) {
        this.isStdErr = isStdErr;
        this.sinkIdentifier = sinkIdentifier == null ? "" : sinkIdentifier;
    }

    public void open(int subtaskIndex, int numParallelSubtasks) {
        this.stream = this.isStdErr ? System.err : System.out;
        this.completedPrefix = this.sinkIdentifier;
        if (numParallelSubtasks > 1) {
            if (!this.completedPrefix.isEmpty()) {
                this.completedPrefix = this.completedPrefix + ":";
            }
            this.completedPrefix = this.completedPrefix + (subtaskIndex + 1);
        }
        if (!this.completedPrefix.isEmpty()) {
            this.completedPrefix = this.completedPrefix + "> ";
        }
    }

    public void write(IN record) {
        this.stream.println(this.completedPrefix + record.toString());
    }

    @Override
    public void write(IN element, SinkWriter.Context context) throws IOException, InterruptedException {
        this.write(element);
    }

    @Override
    public void flush(boolean endOfInput) throws IOException, InterruptedException {
        this.stream.flush();
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return "Print to " + (this.isStdErr ? "System.err" : "System.out");
    }
}

