/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.MemorySize;

@Experimental
public class SlotSharingGroup {
    private final String name;
    @Nullable
    private final Double cpuCores;
    @Nullable
    private final MemorySize taskHeapMemory;
    @Nullable
    private final MemorySize taskOffHeapMemory;
    @Nullable
    private final MemorySize managedMemory;
    private final Map<String, Double> externalResources;

    private SlotSharingGroup(String name, @Nullable Double cpuCores, @Nullable MemorySize taskHeapMemory, @Nullable MemorySize taskOffHeapMemory, @Nullable MemorySize managedMemory, Map<String, Double> extendedResources) {
        this.name = name;
        this.cpuCores = cpuCores;
        this.taskHeapMemory = taskHeapMemory;
        this.taskOffHeapMemory = taskOffHeapMemory;
        this.managedMemory = managedMemory;
        this.externalResources = Collections.unmodifiableMap(extendedResources);
    }

    private SlotSharingGroup(String name) {
        this(name, null, null, null, null, Collections.emptyMap());
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public MemorySize getManagedMemory() {
        return this.managedMemory;
    }

    @Nullable
    public MemorySize getTaskHeapMemory() {
        return this.taskHeapMemory;
    }

    @Nullable
    public MemorySize getTaskOffHeapMemory() {
        return this.taskOffHeapMemory;
    }

    @Nullable
    public Double getCpuCores() {
        return this.cpuCores;
    }

    public Map<String, Double> getExternalResources() {
        return this.externalResources;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == SlotSharingGroup.class) {
            SlotSharingGroup that = (SlotSharingGroup)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapMemory, that.taskHeapMemory) && Objects.equals(this.taskOffHeapMemory, that.taskOffHeapMemory) && Objects.equals(this.managedMemory, that.managedMemory) && Objects.equals(this.externalResources, that.externalResources);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.cpuCores);
        result = 31 * result + Objects.hashCode(this.taskHeapMemory);
        result = 31 * result + Objects.hashCode(this.taskOffHeapMemory);
        result = 31 * result + Objects.hashCode(this.managedMemory);
        result = 31 * result + this.externalResources.hashCode();
        return result;
    }

    @Experimental
    public static class Builder {
        private final String name;
        private Double cpuCores;
        private MemorySize taskHeapMemory;
        private MemorySize taskOffHeapMemory;
        private MemorySize managedMemory;
        private final Map<String, Double> externalResources = new HashMap<String, Double>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder setCpuCores(double cpuCores) {
            if (cpuCores <= 0.0) {
                throw new IllegalArgumentException("The cpu cores should be positive.");
            }
            this.cpuCores = cpuCores;
            return this;
        }

        public Builder setTaskHeapMemory(MemorySize taskHeapMemory) {
            if (taskHeapMemory.compareTo(MemorySize.ZERO) <= 0) {
                throw new IllegalArgumentException("The task heap memory should be positive.");
            }
            this.taskHeapMemory = taskHeapMemory;
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            if (taskHeapMemoryMB <= 0) {
                throw new IllegalArgumentException("The task heap memory should be positive.");
            }
            this.taskHeapMemory = MemorySize.ofMebiBytes(taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemory(MemorySize taskOffHeapMemory) {
            this.taskOffHeapMemory = taskOffHeapMemory;
            return this;
        }

        public Builder setTaskOffHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapMemory = MemorySize.ofMebiBytes(taskOffHeapMemoryMB);
            return this;
        }

        public Builder setManagedMemory(MemorySize managedMemory) {
            this.managedMemory = managedMemory;
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemory = MemorySize.ofMebiBytes(managedMemoryMB);
            return this;
        }

        public Builder setExternalResource(String name, double value) {
            this.externalResources.put(name, value);
            return this;
        }

        public SlotSharingGroup build() {
            if (this.cpuCores != null && this.taskHeapMemory != null) {
                this.taskOffHeapMemory = Optional.ofNullable(this.taskOffHeapMemory).orElse(MemorySize.ZERO);
                this.managedMemory = Optional.ofNullable(this.managedMemory).orElse(MemorySize.ZERO);
                return new SlotSharingGroup(this.name, this.cpuCores, this.taskHeapMemory, this.taskOffHeapMemory, this.managedMemory, this.externalResources);
            }
            if (this.cpuCores != null || this.taskHeapMemory != null || this.taskOffHeapMemory != null || this.managedMemory != null || !this.externalResources.isEmpty()) {
                throw new IllegalArgumentException("The cpu cores and task heap memory are required when specifying the resource of a slot sharing group. You need to explicitly configure them with positive value.");
            }
            return new SlotSharingGroup(this.name);
        }
    }
}

