/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class StaticArgument {
    private static final RowType DUMMY_ROW_TYPE = RowType.of(new NullType());
    private final String name;
    @Nullable
    private final DataType dataType;
    @Nullable
    private final Class<?> conversionClass;
    private final boolean isOptional;
    private final EnumSet<StaticArgumentTrait> traits;

    private StaticArgument(String name, @Nullable DataType dataType, @Nullable Class<?> conversionClass, boolean isOptional, EnumSet<StaticArgumentTrait> traits) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null.");
        this.dataType = dataType;
        this.conversionClass = conversionClass;
        this.isOptional = isOptional;
        this.traits = Preconditions.checkNotNull(traits, "Traits must not be null.");
        this.checkName();
        this.checkTraits(traits);
        this.checkOptionalType();
        this.checkTableType();
    }

    public static StaticArgument scalar(String name, DataType dataType, boolean isOptional) {
        Preconditions.checkNotNull(dataType, "Data type must not be null.");
        return new StaticArgument(name, dataType, null, isOptional, EnumSet.of(StaticArgumentTrait.SCALAR));
    }

    public static StaticArgument table(String name, Class<?> conversionClass, boolean isOptional, EnumSet<StaticArgumentTrait> traits) {
        Preconditions.checkNotNull(conversionClass, "Conversion class must not be null.");
        EnumSet<StaticArgumentTrait> enrichedTraits = EnumSet.copyOf(traits);
        enrichedTraits.add(StaticArgumentTrait.TABLE);
        if (!enrichedTraits.contains((Object)StaticArgumentTrait.TABLE_AS_SET)) {
            enrichedTraits.add(StaticArgumentTrait.TABLE_AS_ROW);
        }
        return new StaticArgument(name, null, conversionClass, isOptional, enrichedTraits);
    }

    public static StaticArgument table(String name, DataType dataType, boolean isOptional, EnumSet<StaticArgumentTrait> traits) {
        Preconditions.checkNotNull(dataType, "Data type must not be null.");
        return new StaticArgument(name, dataType, null, isOptional, StaticArgument.enrichTableTraits(traits));
    }

    private static EnumSet<StaticArgumentTrait> enrichTableTraits(EnumSet<StaticArgumentTrait> traits) {
        EnumSet<StaticArgumentTrait> enrichedTraits = EnumSet.copyOf(traits);
        enrichedTraits.add(StaticArgumentTrait.TABLE);
        if (!enrichedTraits.contains((Object)StaticArgumentTrait.TABLE_AS_SET)) {
            enrichedTraits.add(StaticArgumentTrait.TABLE_AS_ROW);
        }
        return enrichedTraits;
    }

    public String getName() {
        return this.name;
    }

    public Optional<DataType> getDataType() {
        return Optional.ofNullable(this.dataType);
    }

    public Optional<Class<?>> getConversionClass() {
        return Optional.ofNullable(this.conversionClass);
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public EnumSet<StaticArgumentTrait> getTraits() {
        return this.traits;
    }

    public boolean is(StaticArgumentTrait trait) {
        return this.traits.contains((Object)trait);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append(" =>");
        if (this.dataType != null) {
            s.append(" ");
            s.append(this.dataType);
        }
        if (!this.traits.equals(EnumSet.of(StaticArgumentTrait.SCALAR))) {
            s.append(" ");
            s.append(this.traits.stream().map(Enum::name).map(n -> n.replace('_', ' ')).collect(Collectors.joining(", ", "{", "}")));
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticArgument that = (StaticArgument)o;
        return this.isOptional == that.isOptional && Objects.equals(this.name, that.name) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.conversionClass, that.conversionClass) && Objects.equals(this.traits, that.traits);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.conversionClass, this.isOptional, this.traits);
    }

    private void checkName() {
        if (!TypeInference.PARAMETER_NAME_FORMAT.test(this.name)) {
            throw new ValidationException(String.format("Invalid argument name '%s'. An argument must follow the pattern [a-zA-Z_$][a-zA-Z_$0-9]*.", this.name));
        }
    }

    private void checkTraits(EnumSet<StaticArgumentTrait> traits) {
        if (traits.stream().filter(t -> t.getRequirements().isEmpty()).count() != 1L) {
            throw new ValidationException(String.format("Invalid argument traits for argument '%s'. An argument must be declared as either scalar, table, or model.", this.name));
        }
        traits.forEach(trait -> trait.getRequirements().forEach(requirement -> {
            if (!traits.contains(requirement)) {
                throw new ValidationException(String.format("Invalid argument traits for argument '%s'. Trait %s requires %s.", this.name, trait, requirement));
            }
        }));
    }

    private void checkOptionalType() {
        if (!this.isOptional) {
            return;
        }
        if (this.dataType == null) {
            return;
        }
        LogicalType type = this.dataType.getLogicalType();
        if (!type.isNullable() || !type.supportsInputConversion(this.dataType.getConversionClass())) {
            throw new ValidationException(String.format("Invalid data type for optional argument '%s'. An optional argument has to accept null values.", this.name));
        }
    }

    void checkTableType() {
        if (!this.traits.contains((Object)StaticArgumentTrait.TABLE)) {
            return;
        }
        if (this.dataType == null && this.conversionClass != null && !DUMMY_ROW_TYPE.supportsInputConversion(this.conversionClass)) {
            throw new ValidationException(String.format("Invalid conversion class '%s' for argument '%s'. Polymorphic, untyped table arguments must use a row class.", this.conversionClass.getName(), this.name));
        }
        if (this.dataType != null) {
            LogicalType type = this.dataType.getLogicalType();
            if (this.traits.contains((Object)StaticArgumentTrait.TABLE) && !LogicalTypeChecks.isCompositeType(type)) {
                throw new ValidationException(String.format("Invalid data type '%s' for table argument '%s'. Typed table arguments must use a composite type (i.e. row or structured type).", type, this.name));
            }
        }
    }
}

