/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc.utils;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.jdbc.FlinkResultSet;
import org.apache.flink.table.jdbc.utils.CollectionResultIterator;
import org.apache.flink.table.types.DataType;

public class DatabaseMetaDataUtils {
    private static final Column TABLE_CAT_COLUMN = Column.physical("TABLE_CAT", (DataType)DataTypes.STRING().notNull());
    private static final Column TABLE_SCHEM_COLUMN = Column.physical("TABLE_SCHEM", (DataType)DataTypes.STRING().notNull());
    private static final Column TABLE_CATALOG_COLUMN = Column.physical("TABLE_CATALOG", DataTypes.STRING());

    public static FlinkResultSet createCatalogsResultSet(Statement statement, StatementResult result) {
        ArrayList<RowData> catalogs = new ArrayList<RowData>();
        result.forEachRemaining(catalogs::add);
        catalogs.sort(Comparator.comparing(v -> v.getString(0)));
        return new FlinkResultSet(statement, new CollectionResultIterator(catalogs.iterator()), ResolvedSchema.of(TABLE_CAT_COLUMN));
    }

    public static FlinkResultSet createSchemasResultSet(Statement statement, List<String> catalogs, Map<String, List<String>> catalogSchemas) {
        ArrayList schemaWithCatalogList = new ArrayList();
        ArrayList<String> catalogList = new ArrayList<String>(catalogs);
        catalogList.sort(String::compareTo);
        for (String catalog : catalogList) {
            List<String> schemas = catalogSchemas.get(catalog);
            schemas.sort(String::compareTo);
            schemas.forEach(s -> schemaWithCatalogList.add(GenericRowData.of(StringData.fromString(s), StringData.fromString(catalog))));
        }
        return new FlinkResultSet(statement, new CollectionResultIterator(schemaWithCatalogList.iterator()), ResolvedSchema.of(TABLE_SCHEM_COLUMN, TABLE_CATALOG_COLUMN));
    }
}

