/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.results;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;

@PublicEvolving
public class FunctionInfo {
    private final FunctionIdentifier identifier;
    @Nullable
    private final FunctionKind kind;

    public FunctionInfo(FunctionIdentifier identifier) {
        this(identifier, null);
    }

    public FunctionInfo(FunctionIdentifier identifier, @Nullable FunctionKind kind) {
        this.identifier = identifier;
        this.kind = kind;
    }

    public FunctionIdentifier getIdentifier() {
        return this.identifier;
    }

    public Optional<FunctionKind> getKind() {
        return Optional.ofNullable(this.kind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionInfo)) {
            return false;
        }
        FunctionInfo that = (FunctionInfo)o;
        return Objects.equals(this.identifier, that.identifier) && this.kind == that.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.kind});
    }

    public String toString() {
        return "FunctionInfo{identifier=" + this.identifier + ", kind=" + this.kind + "}";
    }
}

