/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;

public class CollectCoordinationResponse
implements CoordinationResponse {
    private static final long serialVersionUID = 1L;
    private static final TypeSerializer<String> versionSerializer = StringSerializer.INSTANCE;
    private static final TypeSerializer<Long> offsetSerializer = LongSerializer.INSTANCE;
    private static final ListSerializer<byte[]> bufferSerializer = new ListSerializer<byte[]>(BytePrimitiveArraySerializer.INSTANCE);
    private final String version;
    private final long lastCheckpointedOffset;
    private final List<byte[]> serializedResults;

    public CollectCoordinationResponse(String version, long lastCheckpointedOffset, List<byte[]> serializedResults) {
        this.version = version;
        this.lastCheckpointedOffset = lastCheckpointedOffset;
        this.serializedResults = serializedResults;
    }

    public CollectCoordinationResponse(DataInputView inView) throws IOException {
        this.version = versionSerializer.deserialize(inView);
        this.lastCheckpointedOffset = offsetSerializer.deserialize(inView);
        this.serializedResults = bufferSerializer.deserialize(inView);
    }

    public String getVersion() {
        return this.version;
    }

    public long getLastCheckpointedOffset() {
        return this.lastCheckpointedOffset;
    }

    public <T> List<T> getResults(TypeSerializer<T> elementSerializer) throws IOException {
        ArrayList<T> results = new ArrayList<T>();
        for (byte[] serializedResult : this.serializedResults) {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedResult);
            DataInputViewStreamWrapper wrapper = new DataInputViewStreamWrapper(bais);
            results.add(elementSerializer.deserialize(wrapper));
        }
        return results;
    }

    public void serialize(DataOutputView outView) throws IOException {
        versionSerializer.serialize(this.version, outView);
        offsetSerializer.serialize(this.lastCheckpointedOffset, outView);
        bufferSerializer.serialize(this.serializedResults, outView);
    }
}

