/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamEdge;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;

@Internal
public class ImmutableStreamNode {
    private final StreamNode streamNode;
    private List<ImmutableStreamEdge> immutableOutEdges = null;
    private List<ImmutableStreamEdge> immutableInEdges = null;

    public ImmutableStreamNode(StreamNode streamNode) {
        this.streamNode = streamNode;
    }

    public List<ImmutableStreamEdge> getOutEdges() {
        if (this.immutableOutEdges == null) {
            this.immutableOutEdges = new ArrayList<ImmutableStreamEdge>();
            for (StreamEdge edge : this.streamNode.getOutEdges()) {
                this.immutableOutEdges.add(new ImmutableStreamEdge(edge));
            }
        }
        return Collections.unmodifiableList(this.immutableOutEdges);
    }

    public List<ImmutableStreamEdge> getInEdges() {
        if (this.immutableInEdges == null) {
            this.immutableInEdges = new ArrayList<ImmutableStreamEdge>();
            for (StreamEdge edge : this.streamNode.getInEdges()) {
                this.immutableInEdges.add(new ImmutableStreamEdge(edge));
            }
        }
        return Collections.unmodifiableList(this.immutableInEdges);
    }

    public int getId() {
        return this.streamNode.getId();
    }

    @Nullable
    public StreamOperatorFactory<?> getOperatorFactory() {
        return this.streamNode.getOperatorFactory();
    }

    public int getMaxParallelism() {
        return this.streamNode.getMaxParallelism();
    }

    public int getParallelism() {
        return this.streamNode.getParallelism();
    }

    public TypeSerializer<?>[] getTypeSerializersIn() {
        return (TypeSerializer[])Arrays.stream(this.streamNode.getTypeSerializersIn()).filter(Objects::nonNull).toArray(TypeSerializer[]::new);
    }

    public String toString() {
        return this.streamNode.toString();
    }
}

