/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.util.SerializedValue;

@Internal
public interface ExecutionPlan
extends Serializable {
    public JobID getJobID();

    public String getName();

    public JobType getJobType();

    public boolean isDynamic();

    public JobCheckpointingSettings getCheckpointingSettings();

    public boolean isEmpty();

    public long getInitialClientHeartbeatTimeout();

    public boolean isPartialResourceConfigured();

    public int getMaximumParallelism();

    public Configuration getJobConfiguration();

    public List<Path> getUserJars();

    public List<PermanentBlobKey> getUserJarBlobKeys();

    public List<URL> getClasspaths();

    public Map<String, DistributedCache.DistributedCacheEntry> getUserArtifacts();

    public void addUserJarBlobKey(PermanentBlobKey var1);

    public void setUserArtifactBlobKey(String var1, PermanentBlobKey var2) throws IOException;

    public void writeUserArtifactEntriesToConfiguration();

    public SavepointRestoreSettings getSavepointRestoreSettings();

    public void setSavepointRestoreSettings(SavepointRestoreSettings var1);

    default public boolean isCheckpointingEnabled() {
        JobCheckpointingSettings checkpointingSettings = this.getCheckpointingSettings();
        if (checkpointingSettings == null) {
            return false;
        }
        return checkpointingSettings.getCheckpointCoordinatorConfiguration().isCheckpointingEnabled();
    }

    public SerializedValue<ExecutionConfig> getSerializedExecutionConfig();
}

