/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.declare.state;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.runtime.asyncprocessing.declare.DeclaredVariable;
import org.apache.flink.runtime.asyncprocessing.declare.state.AggregatingStateWithDeclaredNamespace;
import org.apache.flink.runtime.asyncprocessing.declare.state.ListStateWithDeclaredNamespace;
import org.apache.flink.runtime.asyncprocessing.declare.state.MapStateWithDeclaredNamespace;
import org.apache.flink.runtime.asyncprocessing.declare.state.ReducingStateWithDeclaredNamespace;
import org.apache.flink.runtime.asyncprocessing.declare.state.ValueStateWithDeclaredNamespace;
import org.apache.flink.runtime.state.v2.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.v2.internal.InternalKeyedState;
import org.apache.flink.runtime.state.v2.internal.InternalListState;
import org.apache.flink.runtime.state.v2.internal.InternalMapState;
import org.apache.flink.runtime.state.v2.internal.InternalReducingState;
import org.apache.flink.runtime.state.v2.internal.InternalValueState;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StateWithDeclaredNamespace<K, N, V>
implements InternalKeyedState<K, N, V> {
    @Nonnull
    private final InternalKeyedState<K, N, V> state;
    @Nonnull
    private final DeclaredVariable<N> declaredNamespace;

    public StateWithDeclaredNamespace(@Nonnull InternalKeyedState<K, N, V> state, @Nonnull DeclaredVariable<N> declaredNamespace) {
        Preconditions.checkNotNull(state);
        Preconditions.checkNotNull(declaredNamespace);
        this.state = state;
        this.declaredNamespace = declaredNamespace;
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.declaredNamespace.set(namespace);
        this.state.setCurrentNamespace(namespace);
    }

    protected void resetNamespace() {
        this.state.setCurrentNamespace(this.declaredNamespace.get());
    }

    public static <N, S extends State> S create(S state, DeclaredVariable<N> declaredNamespace) {
        if (state instanceof InternalReducingState) {
            return (S)new ReducingStateWithDeclaredNamespace((InternalReducingState)state, declaredNamespace);
        }
        if (state instanceof InternalAggregatingState) {
            return (S)new AggregatingStateWithDeclaredNamespace((InternalAggregatingState)state, declaredNamespace);
        }
        if (state instanceof InternalValueState) {
            return (S)new ValueStateWithDeclaredNamespace((InternalValueState)state, declaredNamespace);
        }
        if (state instanceof InternalMapState) {
            return (S)new MapStateWithDeclaredNamespace((InternalMapState)state, declaredNamespace);
        }
        if (state instanceof InternalListState) {
            return (S)new ListStateWithDeclaredNamespace((InternalListState)state, declaredNamespace);
        }
        throw new IllegalArgumentException("Unsupported state type: " + state.getClass().getName());
    }
}

