/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.description.BlockElement;
import org.apache.flink.configuration.description.Formatter;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.shaded.guava32.com.google.common.base.Strings;

@PublicEvolving
public class TextElement
implements BlockElement,
InlineElement {
    private final String format;
    private final List<InlineElement> elements;
    private final EnumSet<TextStyle> textStyles = EnumSet.noneOf(TextStyle.class);

    public static TextElement text(String format, InlineElement ... elements) {
        return new TextElement(format, Arrays.asList(elements));
    }

    public static TextElement text(String text) {
        return new TextElement(text, Collections.emptyList());
    }

    public static InlineElement wrap(InlineElement ... elements) {
        return TextElement.text(Strings.repeat("%s", elements.length), elements);
    }

    public static TextElement code(String text) {
        TextElement element = TextElement.text(text);
        element.textStyles.add(TextStyle.CODE);
        return element;
    }

    public String getFormat() {
        return this.format;
    }

    public List<InlineElement> getElements() {
        return this.elements;
    }

    public EnumSet<TextStyle> getStyles() {
        return this.textStyles;
    }

    private TextElement(String format, List<InlineElement> elements) {
        this.format = format;
        this.elements = elements;
    }

    @Override
    public void format(Formatter formatter) {
        formatter.format(this);
    }

    @PublicEvolving
    public static enum TextStyle {
        CODE;

    }
}

