/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.Preconditions;

@Internal
public class UnsuccessfulExecutionException
extends JobExecutionException {
    private final ApplicationStatus status;

    public UnsuccessfulExecutionException(JobID jobID, ApplicationStatus status, String message, Throwable cause) {
        super(jobID, message, cause);
        this.status = Preconditions.checkNotNull(status);
    }

    public ApplicationStatus getStatus() {
        return this.status;
    }

    public static UnsuccessfulExecutionException fromJobResult(JobResult result, ClassLoader userClassLoader) {
        Preconditions.checkState(result != null && !result.isSuccess());
        Preconditions.checkNotNull(userClassLoader);
        try {
            result.toJobExecutionResult(userClassLoader);
            throw new IllegalStateException("No exception thrown although the job execution was not successful.");
        }
        catch (Throwable t) {
            JobID jobID = result.getJobId();
            ApplicationStatus status = result.getApplicationStatus();
            return status == ApplicationStatus.CANCELED || status == ApplicationStatus.FAILED ? new UnsuccessfulExecutionException(jobID, status, "Application Status: " + status.name(), t) : new UnsuccessfulExecutionException(jobID, ApplicationStatus.UNKNOWN, "Job failed for unknown reason.", t);
        }
    }
}

