/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.AbstractUdfOperator;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.util.Visitor;

@Internal
public abstract class SingleInputOperator<IN, OUT, FT extends Function>
extends AbstractUdfOperator<OUT, FT> {
    protected Operator<IN> input;
    private final int[] keyFields;
    private SingleInputSemanticProperties semanticProperties = new SingleInputSemanticProperties();

    protected SingleInputOperator(UserCodeWrapper<FT> stub, UnaryOperatorInformation<IN, OUT> operatorInfo, int[] keyPositions, String name) {
        super(stub, operatorInfo, name);
        this.keyFields = keyPositions;
    }

    protected SingleInputOperator(UserCodeWrapper<FT> stub, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(stub, operatorInfo, name);
        this.keyFields = new int[0];
    }

    public UnaryOperatorInformation<IN, OUT> getOperatorInfo() {
        return (UnaryOperatorInformation)this.operatorInfo;
    }

    public Operator<IN> getInput() {
        return this.input;
    }

    public void clearInputs() {
        this.input = null;
    }

    public void setInput(Operator<IN> input) {
        this.input = input;
    }

    public SingleInputSemanticProperties getSemanticProperties() {
        return this.semanticProperties;
    }

    public void setSemanticProperties(SingleInputSemanticProperties semanticProperties) {
        this.semanticProperties = semanticProperties;
    }

    @Override
    public final int getNumberOfInputs() {
        return 1;
    }

    @Override
    public int[] getKeyColumns(int inputNum) {
        if (inputNum == 0) {
            return this.keyFields;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        if (visitor.preVisit(this)) {
            this.input.accept(visitor);
            for (Operator c : this.broadcastInputs.values()) {
                c.accept(visitor);
            }
            visitor.postVisit(this);
        }
    }

    protected abstract List<OUT> executeOnCollections(List<IN> var1, RuntimeContext var2, ExecutionConfig var3) throws Exception;
}

