/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.jdbc.ColumnInfo;
import org.apache.flink.table.types.DataType;

public class FlinkResultSetMetaData
implements ResultSetMetaData {
    private final List<ColumnInfo> columnList;

    public FlinkResultSetMetaData(List<String> columnNames, List<DataType> columnTypes) {
        this.columnList = new ArrayList<ColumnInfo>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            this.columnList.add(ColumnInfo.fromLogicalType(columnNames.get(i), columnTypes.get(i).getLogicalType()));
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnList.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkIndexBound(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkIndexBound(column);
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkIndexBound(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkIndexBound(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkIndexBound(column);
        boolean nullable = this.column(column).isNullable();
        return nullable ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).getColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getSchemaName is not supported");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getTableName is not supported");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getCatalogName is not supported");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).getColumnType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.column(column).columnTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkIndexBound(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkIndexBound(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkIndexBound(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return FlinkResultSetMetaData.getType(this.getColumnType(column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#unwrap is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isWrapperFor is not supported");
    }

    private ColumnInfo column(int columnIndex) {
        return this.columnList.get(columnIndex - 1);
    }

    private void checkIndexBound(int column) throws SQLException {
        int columnNum = this.getColumnCount();
        if (column <= 0) {
            throw new SQLException(String.format("Column index[%s] must be positive.", column));
        }
        if (column > columnNum) {
            throw new SQLException(String.format("Column index %s out of bound. There are only %s columns.", column, columnNum));
        }
    }

    static String getType(int type) throws SQLException {
        switch (type) {
            case 2: 
            case 3: {
                return BigDecimal.class.getName();
            }
            case -7: 
            case 16: {
                return Boolean.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 6: 
            case 7: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 1: 
            case 12: {
                return String.class.getName();
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return Date.class.getName();
            }
            case 92: {
                return Time.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 2014: {
                return OffsetDateTime.class.getName();
            }
            case 2000: {
                return Map.class.getName();
            }
            case 2003: {
                return Array.class.getName();
            }
            case 2002: {
                return RowData.class.getName();
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Not support data type [%s]", type));
    }
}

