/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;

public final class ResourceCounter {
    private final Map<ResourceProfile, Integer> resources;

    private ResourceCounter(Map<ResourceProfile, Integer> resources) {
        this.resources = Collections.unmodifiableMap(resources);
    }

    public int getResourceCount(ResourceProfile resourceProfile) {
        return this.resources.getOrDefault(resourceProfile, 0);
    }

    public int getTotalResourceCount() {
        return this.resources.isEmpty() ? 0 : this.resources.values().stream().reduce(0, Integer::sum);
    }

    public ResourceProfile getTotalResource() {
        return this.resources.entrySet().stream().map(entry -> ((ResourceProfile)entry.getKey()).multiply((Integer)entry.getValue())).reduce(ResourceProfile.ZERO, ResourceProfile::merge);
    }

    public ResourceCounter add(ResourceCounter increment) {
        return this.internalAdd(increment.getResourcesWithCount());
    }

    public ResourceCounter add(Map<ResourceProfile, Integer> increment) {
        return this.internalAdd(increment.entrySet());
    }

    public ResourceCounter add(ResourceProfile resourceProfile, int increment) {
        HashMap<ResourceProfile, Integer> newValues = new HashMap<ResourceProfile, Integer>(this.resources);
        int newValue = this.resources.getOrDefault(resourceProfile, 0) + increment;
        this.updateNewValue(newValues, resourceProfile, newValue);
        return new ResourceCounter(newValues);
    }

    private ResourceCounter internalAdd(Iterable<? extends Map.Entry<ResourceProfile, Integer>> entries) {
        HashMap<ResourceProfile, Integer> newValues = new HashMap<ResourceProfile, Integer>(this.resources);
        for (Map.Entry<ResourceProfile, Integer> entry : entries) {
            ResourceProfile resourceProfile = entry.getKey();
            int newValue = this.resources.getOrDefault(resourceProfile, 0) + entry.getValue();
            this.updateNewValue(newValues, resourceProfile, newValue);
        }
        return new ResourceCounter(newValues);
    }

    private void updateNewValue(Map<ResourceProfile, Integer> newResources, ResourceProfile resourceProfile, int newValue) {
        if (newValue > 0) {
            newResources.put(resourceProfile, newValue);
        } else {
            newResources.remove(resourceProfile);
        }
    }

    public ResourceCounter subtract(ResourceCounter decrement) {
        return this.internalSubtract(decrement.getResourcesWithCount());
    }

    public ResourceCounter subtract(Map<ResourceProfile, Integer> decrement) {
        return this.internalSubtract(decrement.entrySet());
    }

    public ResourceCounter subtract(ResourceProfile resourceProfile, int decrement) {
        HashMap<ResourceProfile, Integer> newValues = new HashMap<ResourceProfile, Integer>(this.resources);
        int newValue = this.resources.getOrDefault(resourceProfile, 0) - decrement;
        this.updateNewValue(newValues, resourceProfile, newValue);
        return new ResourceCounter(newValues);
    }

    private ResourceCounter internalSubtract(Iterable<? extends Map.Entry<ResourceProfile, Integer>> entries) {
        HashMap<ResourceProfile, Integer> newValues = new HashMap<ResourceProfile, Integer>(this.resources);
        for (Map.Entry<ResourceProfile, Integer> entry : entries) {
            ResourceProfile resourceProfile = entry.getKey();
            int newValue = this.resources.getOrDefault(resourceProfile, 0) - entry.getValue();
            this.updateNewValue(newValues, resourceProfile, newValue);
        }
        return new ResourceCounter(newValues);
    }

    public Collection<Map.Entry<ResourceProfile, Integer>> getResourcesWithCount() {
        return this.resources.entrySet();
    }

    public boolean containsResource(ResourceProfile resourceProfile) {
        return this.resources.containsKey(resourceProfile);
    }

    public Set<ResourceProfile> getResources() {
        return this.resources.keySet();
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public static ResourceCounter empty() {
        return new ResourceCounter(Collections.emptyMap());
    }

    public static ResourceCounter withResources(Map<ResourceProfile, Integer> resources) {
        return new ResourceCounter(new HashMap<ResourceProfile, Integer>(resources));
    }

    public static ResourceCounter withResource(ResourceProfile resourceProfile, int count) {
        Preconditions.checkArgument(count >= 0);
        return count == 0 ? ResourceCounter.empty() : new ResourceCounter(Collections.singletonMap(resourceProfile, count));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCounter that = (ResourceCounter)o;
        return Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }

    public String toString() {
        return "ResourceCounter{resources=" + this.resources + "}";
    }
}

