/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.runtime.asyncprocessing.AbstractStateIterator;

public class SyncIteratorWrapper<T>
implements Iterator<T> {
    private final ArrayList<T> cacheEntries = new ArrayList();
    private int cacheIndex = 0;

    public SyncIteratorWrapper(StateIterator<T> stateIterator) {
        if (stateIterator instanceof AbstractStateIterator) {
            ((AbstractStateIterator)stateIterator).onNextSync(this.cacheEntries::add);
        }
    }

    @Override
    public boolean hasNext() {
        return this.cacheIndex < this.cacheEntries.size();
    }

    @Override
    public T next() {
        if (this.cacheIndex == this.cacheEntries.size()) {
            throw new NoSuchElementException("Iterator has no more elements!");
        }
        T currentEntry = this.cacheEntries.get(this.cacheIndex);
        ++this.cacheIndex;
        return currentEntry;
    }
}

