/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.filesystem.MetadataOutputStreamWrapper;

@Internal
public class FSDataOutputStreamWrapper
extends MetadataOutputStreamWrapper {
    private final FileSystem fileSystem;
    private final Path metadataFilePath;
    private final FSDataOutputStream out;

    public FSDataOutputStreamWrapper(FileSystem fileSystem, Path metadataFilePath) throws IOException {
        this.fileSystem = fileSystem;
        this.metadataFilePath = metadataFilePath;
        this.out = fileSystem.create(metadataFilePath, FileSystem.WriteMode.NO_OVERWRITE);
    }

    @Override
    public FSDataOutputStream getOutput() {
        return this.out;
    }

    @Override
    public void closeForCommitAction() throws IOException {
        this.out.close();
    }

    @Override
    public void closeAction() throws IOException {
        this.out.close();
    }

    @Override
    public void cleanup() throws IOException {
        this.fileSystem.delete(this.metadataFilePath, false);
    }
}

