/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.shaded.guava32.com.google.common.escape.Escaper;
import org.apache.flink.shaded.guava32.com.google.common.escape.Escapers;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapTools {
    private static final ConfigOption<Boolean> USE_LOCAL_DEFAULT_TMP_DIRS = ConfigOptions.key("internal.io.tmpdirs.use-local-default").booleanType().defaultValue(false);
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapTools.class);
    private static final Escaper UNIX_SINGLE_QUOTE_ESCAPER = Escapers.builder().addEscape('\'', "'\\''").build();
    private static final Escaper WINDOWS_DOUBLE_QUOTE_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('^', "\"^^\"").build();
    @VisibleForTesting
    static final String IGNORE_UNRECOGNIZED_VM_OPTIONS = "-XX:+IgnoreUnrecognizedVMOptions";
    private static final String DYNAMIC_PROPERTIES_OPT = "D";

    public static void writeConfiguration(Configuration cfg, File file) throws IOException {
        try (FileWriter fwrt = new FileWriter(file);
             PrintWriter out = new PrintWriter(fwrt);){
            for (String s : ConfigurationUtils.convertConfigToWritableLines(cfg, false)) {
                out.println(s);
            }
        }
    }

    public static void substituteDeprecatedConfigKey(Configuration config, String deprecated, String designated) {
        String valueForDeprecated;
        if (!config.containsKey(designated) && (valueForDeprecated = config.getString(deprecated, null)) != null) {
            config.setString(designated, valueForDeprecated);
        }
    }

    public static void substituteDeprecatedConfigPrefix(Configuration config, String deprecatedPrefix, String designatedPrefix) {
        int prefixLen = deprecatedPrefix.length();
        Configuration replacement = new Configuration();
        for (String key : config.keySet()) {
            String newKey;
            if (!key.startsWith(deprecatedPrefix) || config.containsKey(newKey = designatedPrefix + key.substring(prefixLen))) continue;
            replacement.setString(newKey, config.getString(key, null));
        }
        config.addAll(replacement);
    }

    public static Option newDynamicPropertiesOption() {
        return new Option(DYNAMIC_PROPERTIES_OPT, true, "Dynamic properties");
    }

    public static Configuration parseDynamicProperties(CommandLine cmd) {
        Configuration config = new Configuration();
        String[] values = cmd.getOptionValues(DYNAMIC_PROPERTIES_OPT);
        if (values != null) {
            for (String value : values) {
                String[] pair = value.split("=", 2);
                if (pair.length == 1) {
                    config.setString(pair[0], Boolean.TRUE.toString());
                    continue;
                }
                if (pair.length != 2) continue;
                config.setString(pair[0], pair[1]);
            }
        }
        return config;
    }

    private BootstrapTools() {
    }

    public static void updateTmpDirectoriesInConfiguration(Configuration configuration, @Nullable String defaultDirs) {
        if (configuration.contains(CoreOptions.TMP_DIRS)) {
            LOG.info("Overriding Flink's temporary file directories with those specified in the Flink config: {}", (Object)configuration.getValue(CoreOptions.TMP_DIRS));
        } else if (defaultDirs != null) {
            LOG.info("Setting directories for temporary files to: {}", (Object)defaultDirs);
            configuration.set((ConfigOption)CoreOptions.TMP_DIRS, defaultDirs);
            configuration.set((ConfigOption)USE_LOCAL_DEFAULT_TMP_DIRS, (Object)true);
        }
    }

    public static Configuration cloneConfiguration(Configuration configuration) {
        Configuration clonedConfiguration = new Configuration(configuration);
        if (clonedConfiguration.get(USE_LOCAL_DEFAULT_TMP_DIRS).booleanValue()) {
            clonedConfiguration.removeConfig(CoreOptions.TMP_DIRS);
            clonedConfiguration.removeConfig(USE_LOCAL_DEFAULT_TMP_DIRS);
        }
        return clonedConfiguration;
    }

    public static String getDynamicPropertiesAsString(Configuration baseConfig, Configuration targetConfig) {
        CharSequence[] newAddedConfigs = (String[])targetConfig.keySet().stream().flatMap(key -> {
            String baseValue = baseConfig.get(ConfigOptions.key(key).stringType().noDefaultValue());
            String targetValue = targetConfig.get(ConfigOptions.key(key).stringType().noDefaultValue());
            if (!baseConfig.keySet().contains(key) || !baseValue.equals(targetValue)) {
                return Stream.of("-" + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getOpt() + key + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getValueSeparator() + BootstrapTools.escapeForDifferentOS(targetValue));
            }
            return Stream.empty();
        }).toArray(String[]::new);
        return String.join((CharSequence)" ", newAddedConfigs);
    }

    public static String escapeForDifferentOS(String value) {
        if (OperatingSystem.isWindows()) {
            return BootstrapTools.escapeWithDoubleQuote(value);
        }
        return BootstrapTools.escapeWithSingleQuote(value);
    }

    public static String escapeWithSingleQuote(String value) {
        return "'" + UNIX_SINGLE_QUOTE_ESCAPER.escape(value) + "'";
    }

    public static String escapeWithDoubleQuote(String value) {
        return "\"" + WINDOWS_DOUBLE_QUOTE_ESCAPER.escape(value) + "\"";
    }
}

