/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.function.SupplierWithException;

public enum ClientUtils {


    public static void extractAndUploadExecutionPlanFiles(ExecutionPlan executionPlan, SupplierWithException<BlobClient, IOException> clientSupplier) throws FlinkException {
        List<Path> userJars = executionPlan.getUserJars();
        Collection userArtifacts = executionPlan.getUserArtifacts().entrySet().stream().map(entry -> Tuple2.of((String)entry.getKey(), new Path(((DistributedCache.DistributedCacheEntry)entry.getValue()).filePath))).collect(Collectors.toList());
        ClientUtils.uploadExecutionPlanFiles(executionPlan, userJars, userArtifacts, clientSupplier);
    }

    public static void uploadExecutionPlanFiles(ExecutionPlan executionPlan, Collection<Path> userJars, Collection<Tuple2<String, Path>> userArtifacts, SupplierWithException<BlobClient, IOException> clientSupplier) throws FlinkException {
        if (!userJars.isEmpty() || !userArtifacts.isEmpty()) {
            try (BlobClient client = clientSupplier.get();){
                ClientUtils.uploadAndSetUserJars(executionPlan, userJars, client);
                ClientUtils.uploadAndSetUserArtifacts(executionPlan, userArtifacts, client);
            }
            catch (IOException ioe) {
                throw new FlinkException("Could not upload job files.", ioe);
            }
        }
        executionPlan.writeUserArtifactEntriesToConfiguration();
    }

    private static void uploadAndSetUserJars(ExecutionPlan executionPlan, Collection<Path> userJars, BlobClient blobClient) throws IOException {
        Collection<PermanentBlobKey> blobKeys = ClientUtils.uploadUserJars(executionPlan.getJobID(), userJars, blobClient);
        ClientUtils.setUserJarBlobKeys(blobKeys, executionPlan);
    }

    private static Collection<PermanentBlobKey> uploadUserJars(JobID jobId, Collection<Path> userJars, BlobClient blobClient) throws IOException {
        ArrayList<PermanentBlobKey> blobKeys = new ArrayList<PermanentBlobKey>(userJars.size());
        for (Path jar : userJars) {
            PermanentBlobKey blobKey = blobClient.uploadFile(jobId, jar);
            blobKeys.add(blobKey);
        }
        return blobKeys;
    }

    private static void setUserJarBlobKeys(Collection<PermanentBlobKey> blobKeys, ExecutionPlan executionPlan) {
        blobKeys.forEach(executionPlan::addUserJarBlobKey);
    }

    private static void uploadAndSetUserArtifacts(ExecutionPlan executionPlan, Collection<Tuple2<String, Path>> artifactPaths, BlobClient blobClient) throws IOException {
        Collection<Tuple2<String, PermanentBlobKey>> blobKeys = ClientUtils.uploadUserArtifacts(executionPlan.getJobID(), artifactPaths, blobClient);
        ClientUtils.setUserArtifactBlobKeys(executionPlan, blobKeys);
    }

    private static Collection<Tuple2<String, PermanentBlobKey>> uploadUserArtifacts(JobID jobID, Collection<Tuple2<String, Path>> userArtifacts, BlobClient blobClient) throws IOException {
        ArrayList<Tuple2<String, PermanentBlobKey>> blobKeys = new ArrayList<Tuple2<String, PermanentBlobKey>>(userArtifacts.size());
        for (Tuple2<String, Path> userArtifact : userArtifacts) {
            if (((Path)userArtifact.f1).getFileSystem().isDistributedFS()) continue;
            PermanentBlobKey blobKey = blobClient.uploadFile(jobID, (Path)userArtifact.f1);
            blobKeys.add(Tuple2.of((String)userArtifact.f0, blobKey));
        }
        return blobKeys;
    }

    private static void setUserArtifactBlobKeys(ExecutionPlan executionPlan, Collection<Tuple2<String, PermanentBlobKey>> blobKeys) throws IOException {
        for (Tuple2<String, PermanentBlobKey> blobKey : blobKeys) {
            executionPlan.setUserArtifactBlobKey((String)blobKey.f0, (PermanentBlobKey)blobKey.f1);
        }
    }
}

