/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.rest.retry;

import org.apache.flink.client.program.rest.retry.WaitStrategy;
import org.apache.flink.util.Preconditions;

public class ExponentialWaitStrategy
implements WaitStrategy {
    private final long initialWait;
    private final long maxWait;

    public ExponentialWaitStrategy(long initialWait, long maxWait) {
        Preconditions.checkArgument(initialWait > 0L, "initialWait must be positive, was %s", initialWait);
        Preconditions.checkArgument(maxWait > 0L, "maxWait must be positive, was %s", maxWait);
        Preconditions.checkArgument(initialWait <= maxWait, "initialWait must be lower than or equal to maxWait", maxWait);
        this.initialWait = initialWait;
        this.maxWait = maxWait;
    }

    @Override
    public long sleepTime(long attempt) {
        Preconditions.checkArgument(attempt >= 0L, "attempt must not be negative (%s)", attempt);
        long exponentialSleepTime = this.initialWait * Math.round(Math.pow(2.0, attempt));
        return exponentialSleepTime >= 0L && exponentialSleepTime < this.maxWait ? exponentialSleepTime : this.maxWait;
    }
}

