/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.execution.SavepointFormatType;

public class SavepointOptions
extends CommandLineOptions {
    private final String[] args;
    private final SavepointFormatType formatType;
    private boolean dispose;
    private String disposeSavepointPath;
    private String jarFile;
    private boolean isDetached;

    public SavepointOptions(CommandLine line) {
        super(line);
        this.args = line.getArgs();
        this.dispose = line.hasOption(CliFrontendParser.SAVEPOINT_DISPOSE_OPTION.getOpt());
        this.disposeSavepointPath = line.getOptionValue(CliFrontendParser.SAVEPOINT_DISPOSE_OPTION.getOpt());
        this.jarFile = line.getOptionValue(CliFrontendParser.JAR_OPTION.getOpt());
        this.isDetached = line.hasOption(CliFrontendParser.SAVEPOINT_DETACHED_OPTION.getOpt());
        this.formatType = line.hasOption(CliFrontendParser.SAVEPOINT_FORMAT_OPTION) ? (SavepointFormatType)ConfigurationUtils.convertValue(line.getOptionValue(CliFrontendParser.SAVEPOINT_FORMAT_OPTION), SavepointFormatType.class) : SavepointFormatType.DEFAULT;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args;
    }

    public boolean isDispose() {
        return this.dispose;
    }

    public String getSavepointPath() {
        return this.disposeSavepointPath;
    }

    public String getJarFilePath() {
        return this.jarFile;
    }

    public SavepointFormatType getFormatType() {
        return this.formatType;
    }

    public boolean isDetached() {
        return this.isDetached;
    }
}

